/*
 * Decompiled with CFR 0.152.
 */
package xyz.lxie.dubbo.springboot.actuate;

import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.status.Status;
import com.alibaba.dubbo.common.status.StatusChecker;
import com.alibaba.dubbo.common.status.support.StatusUtils;
import com.alibaba.dubbo.rpc.protocol.dubbo.DubboProtocol;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

class DubboStatus {
    private static final List<String> IGNORE_STATS = Collections.singletonList("spring");

    DubboStatus() {
    }

    static Map<String, SimpleStatus> summary() {
        return DubboStatus.status().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, SimpleStatus::of));
    }

    static boolean isHealth() {
        return DubboStatus.isHealth(DubboStatus.status());
    }

    static boolean isHealth(Map<String, Status> status) {
        Status stat = StatusUtils.getSummaryStatus(status);
        return !Status.Level.ERROR.equals((Object)stat.getLevel());
    }

    static Map<String, Status> status() {
        TreeMap<String, Status> statusMap = new TreeMap<String, Status>();
        ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(StatusChecker.class);
        extensionLoader.getSupportedExtensions().stream().filter(name -> !IGNORE_STATS.contains(name)).forEach(name -> {
            Status status;
            StatusChecker extension = (StatusChecker)extensionLoader.getExtension(name);
            if (extension != null && (status = extension.check()) != null && !Status.Level.UNKNOWN.equals((Object)status.getLevel())) {
                statusMap.put((String)name, status);
            }
        });
        return statusMap;
    }

    static Map<String, Set<String>> services() {
        return DubboProtocol.getDubboProtocol().getExporters().stream().map(exporter -> exporter.getInvoker().getInterface()).collect(Collectors.toMap(Class::getName, DubboStatus::getMethods));
    }

    private static Set<String> getMethods(Class<?> face) {
        return Arrays.stream(face.getMethods()).map(Method::getName).collect(Collectors.toSet());
    }

    static class SimpleStatus {
        private final String level;
        private final String message;

        static SimpleStatus of(Map.Entry<String, Status> statusEntry) {
            Status status = statusEntry.getValue();
            return new SimpleStatus(status.getLevel().name(), status.getMessage());
        }

        SimpleStatus(String level, String message) {
            this.level = level;
            this.message = message;
        }

        public String getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

