/*
 * Decompiled with CFR 0.152.
 */
package xyz.lxie.dubbo.springboot;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class DubboHolderListener
implements ApplicationListener {
    private DubboHolder holder = new DubboHolder();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            this.holder.start();
        } else if (event instanceof ContextClosedEvent) {
            this.holder.shutdown();
        }
    }

    static class DubboHolder {
        private static final Logger logger = LoggerFactory.getLogger(DubboHolder.class);
        private static final int CHECK_INTERVAL_IN_SECONDS = 2;
        private volatile Thread holdThread;
        private AtomicBoolean running = new AtomicBoolean(false);
        private int checkIntervalInSeconds;

        public DubboHolder() {
            this(2);
        }

        public DubboHolder(int checkIntervalInSeconds) {
            this.checkIntervalInSeconds = checkIntervalInSeconds;
        }

        public void start() {
            if (this.running.compareAndSet(false, true)) {
                this.holdThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        logger.info("Start dubbo holder thread: " + Thread.currentThread().getName());
                        while (running.get() && !Thread.currentThread().isInterrupted()) {
                            try {
                                TimeUnit.SECONDS.sleep(checkIntervalInSeconds);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        logger.info("Shutdown dubbo holder thread: " + Thread.currentThread().getName());
                    }
                }, "Dubbo-Holder");
                this.holdThread.setDaemon(false);
                this.holdThread.start();
            }
        }

        public void shutdown() {
            if (this.running.compareAndSet(true, false)) {
                this.holdThread.interrupt();
                this.holdThread = null;
            }
        }
    }
}

