/*
 * Decompiled with CFR 0.152.
 */
package xyz.lxie.dubbo.springboot;

import com.alibaba.dubbo.config.spring.AnnotationBean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class DubboApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment env = applicationContext.getEnvironment();
        String scan = env.getProperty("spring.dubbo.scan");
        if (scan != null && !scan.isEmpty()) {
            ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
            AnnotationBean scanner = (AnnotationBean)BeanUtils.instantiate(AnnotationBean.class);
            scanner.setPackage(scan);
            scanner.setApplicationContext((ApplicationContext)applicationContext);
            applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)scanner);
            beanFactory.addBeanPostProcessor((BeanPostProcessor)scanner);
            beanFactory.registerSingleton("annotationBean", (Object)scanner);
        }
    }
}

