/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.commons.file.saveImp;

import com.aliyun.oss.OSSClient;
import com.uccc.commons.file.DefFileNameFactory;
import com.uccc.commons.file.IFileNameFactory;
import com.uccc.commons.file.exception.FileUploadException;
import com.uccc.commons.file.saveImp.IFileSave;
import java.io.InputStream;

public class OOSFileSaveImp
implements IFileSave {
    private String bucket;
    private String savePath;
    private OSSClient client = null;
    private IFileNameFactory nameFactory;

    public OOSFileSaveImp(String accessKeyId, String accessKeySecret, String endpoint, String bucket) {
        this(accessKeyId, accessKeySecret, endpoint, bucket, new DefFileNameFactory());
    }

    public OOSFileSaveImp(String accessKeyId, String accessKeySecret, String endpoint, String bucket, String savePath) {
        this(accessKeyId, accessKeySecret, endpoint, bucket, savePath, new DefFileNameFactory());
    }

    public OOSFileSaveImp(String accessKeyId, String accessKeySecret, String endpoint, String bucket, IFileNameFactory nameFactory) {
        this(accessKeyId, accessKeySecret, endpoint, bucket, "", nameFactory);
    }

    public OOSFileSaveImp(String accessKeyId, String accessKeySecret, String endpoint, String bucket, String savePath, IFileNameFactory nameFactory) {
        this.bucket = bucket;
        this.savePath = savePath;
        this.nameFactory = nameFactory;
        this.client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        this.client.createBucket(bucket);
    }

    @Override
    public String uploadFile(InputStream files, String suffix) {
        try {
            String name = this.nameFactory.createName() + suffix;
            String key = this.savePath + name;
            this.client.putObject(this.bucket, key, files);
            return name;
        }
        catch (Exception e) {
            throw new FileUploadException(e);
        }
    }
}

