/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.commons.file.saveImp;

import com.uccc.commons.file.DefFileNameFactory;
import com.uccc.commons.file.IFileNameFactory;
import com.uccc.commons.file.exception.FileUploadException;
import com.uccc.commons.file.saveImp.IFileSave;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class LocalSave
implements IFileSave {
    private String savePath = "/opt/static/images/";
    private IFileNameFactory nameFactory;

    public LocalSave(String savePath) {
        this(savePath, new DefFileNameFactory());
    }

    public LocalSave(String savePath, IFileNameFactory nameFactory) {
        this.savePath = savePath;
        this.nameFactory = nameFactory;
    }

    @Override
    public String uploadFile(InputStream files, String suffix) {
        String filename = this.nameFactory.createName() + suffix;
        String absolutePath = this.savePath + filename;
        try {
            FileUtils.copyInputStreamToFile((InputStream)files, (File)new File(absolutePath));
            return filename;
        }
        catch (IOException ioe) {
            throw new FileUploadException(ioe);
        }
    }
}

