package com.uccc.commons.file.saveImp;

import java.io.InputStream;

import com.aliyun.oss.OSSClient;
import com.uccc.commons.file.DefFileNameFactory;
import com.uccc.commons.file.IFileNameFactory;
import com.uccc.commons.file.exception.FileUploadException;

/**
 * 阿里云oos存储
 * @author jinmiao
 * <p>
 * see https://help.aliyun.com/document_detail/32008.html?spm=5176.7933691.203620.1.cyJpvj
 * <p>
 * 2016年10月25日
 *
 */
public class OOSFileSaveImp implements IFileSave {
	
	private String bucket;
	
	private String savePath;
	
	private OSSClient client = null;
	
	private IFileNameFactory nameFactory;
	
	
	public OOSFileSaveImp(String accessKeyId,String accessKeySecret,String endpoint,String bucket)
	{
		this(accessKeyId, accessKeySecret, endpoint, bucket,new DefFileNameFactory());
	}
	
	public OOSFileSaveImp(String accessKeyId,String accessKeySecret,String endpoint,String bucket,String savePath)
	{
		this(accessKeyId, accessKeySecret, endpoint, bucket, savePath, new DefFileNameFactory());
	}
	
	public OOSFileSaveImp(String accessKeyId,String accessKeySecret,String endpoint,String bucket,IFileNameFactory nameFactory)
	{
		this(accessKeyId, accessKeySecret, endpoint, bucket, "", nameFactory);
	}
	
	public OOSFileSaveImp(String accessKeyId,String accessKeySecret,String endpoint,String bucket,String savePath,IFileNameFactory nameFactory)
	{
		this.bucket = bucket;
		this.savePath = savePath;
		this.nameFactory = nameFactory;
		client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
		client.createBucket(bucket);
	}
	

	public String uploadFile(InputStream files,String suffix) {
		try {
			String name = nameFactory.createName()+suffix;
			String key = savePath+name;
			client.putObject(bucket, key, files);
			return name;
		} catch (Exception e) {
			throw new FileUploadException(e);
		}
	}
}
