package com.uccc.commons.file.saveImp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.FileUtils;

import com.uccc.commons.file.DefFileNameFactory;
import com.uccc.commons.file.IFileNameFactory;
import com.uccc.commons.file.exception.FileUploadException;

/**
 * 本地存储
 * @author jinmiao
 * 2016年10月25日
 *
 */
public class LocalSave implements IFileSave{

	private String savePath = "/opt/static/images/";

	private IFileNameFactory nameFactory;
	
	public LocalSave(String savePath)
	{
		this(savePath, new DefFileNameFactory());
	}
	
	public LocalSave(String savePath,IFileNameFactory nameFactory)
	{
		this.savePath = savePath;
		this.nameFactory =nameFactory;
	}
	
	public String uploadFile(InputStream files,String suffix) {
		
		String filename = nameFactory.createName()+suffix;
		String absolutePath = savePath + filename;
		try {
			FileUtils.copyInputStreamToFile(files, new File(absolutePath));
			return filename;
		} catch (IOException ioe) {
			throw new FileUploadException(ioe);
		}
	}
}
