/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.commons.jdbc;

import com.uccc.commons.jdbc.BaseDataSourceProperties;
import com.uccc.commons.jdbc.DataSourceMasterProperties;
import com.uccc.commons.jdbc.DataSourceSlaveProperties;
import com.uccc.commons.jdbc.ReadWriteSplittingTranscationManager;
import com.uccc.commons.jdbc.ReplicationRoutingDataSource;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableConfigurationProperties(value={DataSourceMasterProperties.class, DataSourceSlaveProperties.class})
public class DataSourceConfig {
    @Value(value="${datasource.master.maximumPoolSize:10}")
    private int masterMaxPoolSize = 10;
    @Value(value="${datasource.slave.maximumPoolSize:10}")
    private int slaveMaxPoolSize = 10;
    @Value(value="${datasource.master.minimumIdle:0}")
    private int masterMinIdle;
    @Value(value="${datasource.slave.minimumIdle:0}")
    private int slaveMinIdle;
    @Autowired
    private DataSourceMasterProperties masterProperties;
    @Autowired
    private DataSourceSlaveProperties slaveProperties;

    private DataSource masterDataSource() {
        return this.dataSourceBuild(this.masterProperties, this.masterMaxPoolSize, this.masterMinIdle == 0 ? this.masterMaxPoolSize : this.masterMinIdle);
    }

    private DataSource slaveDataSource() {
        return this.dataSourceBuild(this.slaveProperties, this.slaveMaxPoolSize, this.slaveMinIdle == 0 ? this.slaveMaxPoolSize : this.slaveMinIdle);
    }

    @Bean
    public DataSource routingDataSource() {
        ReplicationRoutingDataSource routingDataSource = new ReplicationRoutingDataSource();
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        dataSourceMap.put("write", this.masterDataSource());
        dataSourceMap.put("read", this.slaveDataSource());
        routingDataSource.setTargetDataSources(dataSourceMap);
        routingDataSource.setDefaultTargetDataSource(this.masterDataSource());
        return routingDataSource;
    }

    private DataSource dataSourceBuild(BaseDataSourceProperties properties, int maxPoolSize, int minIdle) {
        DataSource dataSource;
        DataSourceBuilder factory = DataSourceBuilder.create((ClassLoader)properties.getClassLoader()).driverClassName(properties.getDriverClassName()).url(properties.getUrl()).username(properties.getUsername()).password(properties.getPassword());
        if (properties.getType() != null) {
            factory.type(properties.getType());
        }
        if ((dataSource = factory.build()) instanceof HikariDataSource) {
            ((HikariDataSource)dataSource).setMaximumPoolSize(maxPoolSize);
            ((HikariDataSource)dataSource).setMinimumIdle(minIdle);
        }
        return dataSource;
    }

    @Bean
    public PlatformTransactionManager txManager(DataSource dataSource) {
        return new ReadWriteSplittingTranscationManager(dataSource);
    }
}

