/*
 * Decompiled with CFR 0.152.
 */
package ua.mobius.media.server.spi.memory;

import ua.mobius.media.server.concurrent.ConcurrentCyclicFIFO;
import ua.mobius.media.server.spi.memory.ByteFrame;

public class BytePartition {
    protected int size;
    private ConcurrentCyclicFIFO<ByteFrame> heap = new ConcurrentCyclicFIFO();

    protected BytePartition(int size) {
        this.size = size;
    }

    protected ByteFrame allocate() {
        ByteFrame result = (ByteFrame)this.heap.poll();
        if (result == null) {
            return new ByteFrame(this, new byte[this.size]);
        }
        result.inPartition.set(false);
        return result;
    }

    protected void recycle(ByteFrame frame) {
        if (frame.inPartition.getAndSet(true)) {
            return;
        }
        frame.setHeader(null);
        frame.setDuration(Long.MAX_VALUE);
        frame.setEOM(false);
        this.heap.offer((Object)frame);
    }
}

