/*
 * Decompiled with CFR 0.152.
 */
package ua.mobius.media.server.spi.listener;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import ua.mobius.media.server.spi.listener.Event;
import ua.mobius.media.server.spi.listener.Listener;
import ua.mobius.media.server.spi.listener.TooManyListenersException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Listeners<L extends Listener> {
    private ArrayList<Listener> list = new ArrayList();
    private ArrayList<Listener> processingList = new ArrayList();
    private Semaphore accessSemaphore = new Semaphore(1);

    public void add(L listener) throws TooManyListenersException {
        try {
            this.accessSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.list.add((Listener)listener);
        this.accessSemaphore.release();
    }

    public void remove(L listener) {
        try {
            this.accessSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.list.remove(listener);
        this.accessSemaphore.release();
    }

    public void clear() {
        try {
            this.accessSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.list.clear();
        this.accessSemaphore.release();
    }

    public boolean dispatch(Event event) {
        try {
            this.accessSemaphore.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.processingList.clear();
        this.processingList.addAll(this.list);
        this.accessSemaphore.release();
        boolean res = this.processingList.size() != 0;
        for (int i = 0; i < this.processingList.size(); ++i) {
            this.processingList.get(i).process(event);
        }
        return res;
    }
}

