/*
 * Decompiled with CFR 0.152.
 */
package ua.mobius.media.server.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import ua.mobius.media.server.scheduler.TaskListener;

public abstract class Task
implements Runnable {
    private static AtomicInteger id = new AtomicInteger(0);
    private volatile boolean isActive = true;
    private volatile boolean isHeartbeat = true;
    protected TaskListener listener;
    private final Object LOCK = new Object();
    private AtomicBoolean inQueue0 = new AtomicBoolean(false);
    private AtomicBoolean inQueue1 = new AtomicBoolean(false);
    private Logger logger = Logger.getLogger(Task.class);
    protected int taskId = id.incrementAndGet();

    public void storedInQueue0() {
        this.inQueue0.set(true);
    }

    public void storedInQueue1() {
        this.inQueue1.set(true);
    }

    public void removeFromQueue0() {
        this.inQueue0.set(false);
    }

    public void removeFromQueue1() {
        this.inQueue1.set(false);
    }

    public Boolean isInQueue0() {
        return this.inQueue0.get();
    }

    public Boolean isInQueue1() {
        return this.inQueue1.get();
    }

    public void setListener(TaskListener listener) {
        this.listener = listener;
    }

    public abstract int getQueueNumber();

    public abstract long perform();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.LOCK;
        synchronized (object) {
            this.isActive = false;
        }
    }

    public void run() {
        if (this.isActive) {
            try {
                this.perform();
                if (this.listener != null) {
                    this.listener.onTerminate();
                }
            }
            catch (Exception e) {
                if (this.listener != null) {
                    this.listener.handlerError(e);
                }
                this.logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(Boolean isHeartbeat) {
        Object object = this.LOCK;
        synchronized (object) {
            this.isActive = true;
            this.isHeartbeat = isHeartbeat;
        }
    }
}

