/*
 * Decompiled with CFR 0.152.
 */
package ua.mobius.media.server.scheduler;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.log4j.Logger;
import ua.mobius.media.server.concurrent.ConcurrentCyclicFIFO;
import ua.mobius.media.server.scheduler.Clock;
import ua.mobius.media.server.scheduler.OrderedTaskQueue;
import ua.mobius.media.server.scheduler.Task;
import ua.mobius.media.server.scheduler.TaskChain;

public class Scheduler {
    public static final Integer RECEIVER_QUEUE = 0;
    public static final Integer SENDER_QUEUE = 1;
    public static final Integer MANAGEMENT_QUEUE = 2;
    public static final Integer UDP_MANAGER_QUEUE = 3;
    public static final Integer INPUT_QUEUE = 4;
    public static final Integer MIXER_MIX_QUEUE = 5;
    public static final Integer OUTPUT_QUEUE = 6;
    public static final Integer HEARTBEAT_QUEUE = -1;
    private Clock clock;
    protected OrderedTaskQueue[] taskQueues = new OrderedTaskQueue[7];
    protected OrderedTaskQueue[] heartBeatQueue = new OrderedTaskQueue[5];
    private CoreThread coreThread;
    private CriticalThread criticalThread;
    private boolean isActive;
    private Logger logger = Logger.getLogger(Scheduler.class);
    private ConcurrentCyclicFIFO<Task> waitingTasks = new ConcurrentCyclicFIFO();
    private ConcurrentCyclicFIFO<Task> criticalTasks = new ConcurrentCyclicFIFO();
    private WorkerThread[] workerThreads;
    private CriticalWorkerThread[] criticalWorkerThreads;

    public Scheduler() {
        int i;
        for (i = 0; i < this.taskQueues.length; ++i) {
            this.taskQueues[i] = new OrderedTaskQueue();
        }
        for (i = 0; i < this.heartBeatQueue.length; ++i) {
            this.heartBeatQueue[i] = new OrderedTaskQueue();
        }
        this.coreThread = new CoreThread(String.format("Scheduler", new Object[0]));
        this.criticalThread = new CriticalThread(String.format("Scheduler", new Object[0]));
        this.workerThreads = new WorkerThread[Runtime.getRuntime().availableProcessors() * 2];
        this.criticalWorkerThreads = new CriticalWorkerThread[Runtime.getRuntime().availableProcessors() * 2];
        for (i = 0; i < this.workerThreads.length; ++i) {
            this.workerThreads[i] = new WorkerThread();
        }
        for (i = 0; i < this.criticalWorkerThreads.length; ++i) {
            this.criticalWorkerThreads[i] = new CriticalWorkerThread();
        }
    }

    public int getPoolSize() {
        return this.workerThreads.length;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void submit(Task task, Integer index) {
        task.activate(false);
        this.taskQueues[index].accept(task);
    }

    public void submitHeatbeat(Task task) {
        task.activate(true);
        this.heartBeatQueue[this.coreThread.runIndex].accept(task);
    }

    public void submit(TaskChain taskChain) {
        taskChain.start(MANAGEMENT_QUEUE);
    }

    public void start() {
        int i;
        if (this.isActive) {
            return;
        }
        if (this.clock == null) {
            throw new IllegalStateException("Clock is not set");
        }
        this.isActive = true;
        this.logger.info((Object)"Starting ");
        this.coreThread.activate();
        this.criticalThread.activate();
        for (i = 0; i < this.workerThreads.length; ++i) {
            this.workerThreads[i].activate();
        }
        for (i = 0; i < this.criticalWorkerThreads.length; ++i) {
            this.criticalWorkerThreads[i].activate();
        }
        this.logger.info((Object)"Started ");
    }

    public void stop() {
        int i;
        int i2;
        if (!this.isActive) {
            return;
        }
        this.coreThread.shutdown();
        this.criticalThread.shutdown();
        for (i2 = 0; i2 < this.workerThreads.length; ++i2) {
            this.workerThreads[i2].shutdown();
        }
        for (i2 = 0; i2 < this.criticalWorkerThreads.length; ++i2) {
            this.criticalWorkerThreads[i2].shutdown();
        }
        try {
            Thread.sleep(40L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (i = 0; i < this.taskQueues.length; ++i) {
            this.taskQueues[i].clear();
        }
        for (i = 0; i < this.heartBeatQueue.length; ++i) {
            this.heartBeatQueue[i].clear();
        }
    }

    public double getMissRate() {
        return 0.0;
    }

    public long getWorstExecutionTime() {
        return 0L;
    }

    private class CriticalWorkerThread
    extends Thread {
        private volatile boolean active;
        private Task current;

        private CriticalWorkerThread() {
        }

        public void run() {
            while (this.active) {
                this.current = null;
                while (this.current == null) {
                    try {
                        this.current = (Task)Scheduler.this.criticalTasks.take();
                    }
                    catch (Exception exception) {}
                }
                this.current.run();
                Scheduler.this.criticalThread.notifyCompletion();
            }
        }

        public void activate() {
            this.active = true;
            this.start();
        }

        private void shutdown() {
            this.active = false;
        }
    }

    private class WorkerThread
    extends Thread {
        private volatile boolean active;
        private Task current;

        private WorkerThread() {
        }

        public void run() {
            while (this.active) {
                this.current = null;
                while (this.current == null) {
                    try {
                        this.current = (Task)Scheduler.this.waitingTasks.take();
                    }
                    catch (Exception exception) {}
                }
                this.current.run();
                Scheduler.this.coreThread.notifyCompletion();
            }
        }

        public void activate() {
            this.active = true;
            this.start();
        }

        private void shutdown() {
            this.active = false;
        }
    }

    private class CriticalThread
    extends Thread {
        private volatile boolean active;
        private AtomicInteger activeTasksCount;
        private long cycleStart;
        private Object LOCK;

        public CriticalThread(String name) {
            super(name);
            this.activeTasksCount = new AtomicInteger();
            this.cycleStart = 0L;
            this.LOCK = new Object();
        }

        public void activate() {
            this.active = true;
            this.cycleStart = Scheduler.this.clock.getTime();
            this.start();
        }

        public void notifyCompletion() {
            if (this.activeTasksCount.decrementAndGet() == 0) {
                LockSupport.unpark(Scheduler.this.criticalThread);
            }
        }

        public void run() {
            while (this.active) {
                this.executeQueue(Scheduler.this.taskQueues[RECEIVER_QUEUE]);
                while (this.activeTasksCount.get() != 0) {
                    LockSupport.park();
                }
                this.executeQueue(Scheduler.this.taskQueues[SENDER_QUEUE]);
                while (this.activeTasksCount.get() != 0) {
                    LockSupport.park();
                }
                long cycleDuration = Scheduler.this.clock.getTime() - this.cycleStart;
                if (cycleDuration < 4000000L) {
                    try {
                        CriticalThread.sleep(4L - cycleDuration / 1000000L, (int)((4000000L - cycleDuration) % 1000000L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.cycleStart += 4000000L;
            }
        }

        private void executeQueue(OrderedTaskQueue currQueue) {
            currQueue.changePool();
            Task t = currQueue.poll();
            while (t != null) {
                this.activeTasksCount.incrementAndGet();
                Scheduler.this.criticalTasks.offer((Object)t);
                t = currQueue.poll();
            }
        }

        private void shutdown() {
            this.active = false;
        }
    }

    private class CoreThread
    extends Thread {
        private volatile boolean active;
        private int currQueue;
        private AtomicInteger activeTasksCount;
        private long cycleStart;
        private int runIndex;
        private Object LOCK;

        public CoreThread(String name) {
            super(name);
            this.currQueue = UDP_MANAGER_QUEUE;
            this.activeTasksCount = new AtomicInteger();
            this.cycleStart = 0L;
            this.runIndex = 0;
            this.LOCK = new Object();
        }

        public void activate() {
            this.active = true;
            this.start();
        }

        public void notifyCompletion() {
            if (this.activeTasksCount.decrementAndGet() == 0) {
                LockSupport.unpark(Scheduler.this.coreThread);
            }
        }

        public void run() {
            this.cycleStart = Scheduler.this.clock.getTime();
            while (this.active) {
                long taskStart = this.cycleStart;
                this.currQueue = MANAGEMENT_QUEUE;
                while (this.currQueue <= OUTPUT_QUEUE) {
                    this.executeQueue(Scheduler.this.taskQueues[this.currQueue]);
                    while (this.activeTasksCount.get() != 0) {
                        LockSupport.park();
                    }
                    ++this.currQueue;
                }
                this.executeQueue(Scheduler.this.taskQueues[MANAGEMENT_QUEUE]);
                while (this.activeTasksCount.get() != 0) {
                    LockSupport.park();
                }
                this.runIndex = (this.runIndex + 1) % 5;
                this.executeQueue(Scheduler.this.heartBeatQueue[this.runIndex]);
                while (this.activeTasksCount.get() != 0) {
                    LockSupport.park();
                }
                this.executeQueue(Scheduler.this.taskQueues[MANAGEMENT_QUEUE]);
                while (this.activeTasksCount.get() != 0) {
                    LockSupport.park();
                }
                long cycleDuration = Scheduler.this.clock.getTime() - this.cycleStart;
                if (cycleDuration < 20000000L) {
                    try {
                        CoreThread.sleep(20L - cycleDuration / 1000000L, (int)((20000000L - cycleDuration) % 1000000L));
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.cycleStart += 20000000L;
            }
        }

        private void executeQueue(OrderedTaskQueue currQueue) {
            currQueue.changePool();
            Task t = currQueue.poll();
            while (t != null) {
                this.activeTasksCount.incrementAndGet();
                Scheduler.this.waitingTasks.offer((Object)t);
                t = currQueue.poll();
            }
        }

        private void shutdown() {
            this.active = false;
        }
    }
}

