/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.mapperhelper;

import java.util.ArrayList;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.session.Configuration;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.SelectKeyGenerator;

public class SelectKeyHelper {
    public static void newSelectKeyMappedStatement(MappedStatement ms, EntityColumn column, Class<?> entityClass, Boolean executeBefore, String identity) {
        Object keyGenerator;
        String IDENTITY;
        String keyId = ms.getId() + "!selectKey";
        if (ms.getConfiguration().hasKeyGenerator(keyId)) {
            return;
        }
        Configuration configuration = ms.getConfiguration();
        String string = IDENTITY = column.getGenerator() == null || column.getGenerator().equals("") ? identity : column.getGenerator();
        if (IDENTITY.equalsIgnoreCase("JDBC")) {
            keyGenerator = new Jdbc3KeyGenerator();
        } else {
            RawSqlSource sqlSource = new RawSqlSource(configuration, IDENTITY, entityClass);
            MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, keyId, (SqlSource)sqlSource, SqlCommandType.SELECT);
            statementBuilder.resource(ms.getResource());
            statementBuilder.fetchSize(null);
            statementBuilder.statementType(StatementType.STATEMENT);
            statementBuilder.keyGenerator((KeyGenerator)new NoKeyGenerator());
            statementBuilder.keyProperty(column.getProperty());
            statementBuilder.keyColumn(null);
            statementBuilder.databaseId(null);
            statementBuilder.lang(configuration.getDefaultScriptingLanuageInstance());
            statementBuilder.resultOrdered(false);
            statementBuilder.resulSets(null);
            statementBuilder.timeout(configuration.getDefaultStatementTimeout());
            ArrayList parameterMappings = new ArrayList();
            ParameterMap.Builder inlineParameterMapBuilder = new ParameterMap.Builder(configuration, statementBuilder.id() + "-Inline", entityClass, parameterMappings);
            statementBuilder.parameterMap(inlineParameterMapBuilder.build());
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            ResultMap.Builder inlineResultMapBuilder = new ResultMap.Builder(configuration, statementBuilder.id() + "-Inline", column.getJavaType(), new ArrayList(), null);
            resultMaps.add(inlineResultMapBuilder.build());
            statementBuilder.resultMaps(resultMaps);
            statementBuilder.resultSetType(null);
            statementBuilder.flushCacheRequired(false);
            statementBuilder.useCache(false);
            statementBuilder.cache(null);
            MappedStatement statement = statementBuilder.build();
            try {
                configuration.addMappedStatement(statement);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MappedStatement keyStatement = configuration.getMappedStatement(keyId, false);
            keyGenerator = new SelectKeyGenerator(keyStatement, executeBefore);
            try {
                configuration.addKeyGenerator(keyId, (KeyGenerator)keyGenerator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            MetaObject msObject = SystemMetaObject.forObject((Object)ms);
            msObject.setValue("keyGenerator", keyGenerator);
            msObject.setValue("keyProperties", (Object)column.getTable().getKeyProperties());
            msObject.setValue("keyColumns", (Object)column.getTable().getKeyColumns());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

