/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.spring.mapper;

import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.env.Environment;
import tk.mybatis.mapper.entity.Config;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.util.StringUtil;
import tk.mybatis.spring.mapper.MapperFactoryBean;
import tk.mybatis.spring.mapper.SpringBootBindUtil;

public class ClassPathMapperScanner
extends org.mybatis.spring.mapper.ClassPathMapperScanner {
    private MapperHelper mapperHelper = new MapperHelper();

    public ClassPathMapperScanner(BeanDefinitionRegistry registry) {
        super(registry);
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        this.doAfterScan(beanDefinitions);
        return beanDefinitions;
    }

    protected void doAfterScan(Set<BeanDefinitionHolder> beanDefinitions) {
        this.mapperHelper.ifEmptyRegisterDefaultInterface();
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            if (!StringUtil.isNotEmpty((String)definition.getBeanClassName()) || !definition.getBeanClassName().equals("org.mybatis.spring.mapper.MapperFactoryBean")) continue;
            definition.setBeanClass(MapperFactoryBean.class);
            definition.getPropertyValues().add("mapperHelper", (Object)this.mapperHelper);
        }
    }

    public void setMapperProperties(Environment environment) {
        Config config = SpringBootBindUtil.bind(environment, Config.class, "mapper");
        if (config != null) {
            this.mapperHelper.setConfig(config);
        }
    }
}

