/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.stat;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.tio.utils.SystemTimer;

public class ChannelStat
implements Serializable {
    private static final long serialVersionUID = -6942731710053482089L;
    private int decodeFailCount = 0;
    private long latestTimeOfReceivedPacket = SystemTimer.currentTimeMillis();
    private long latestTimeOfSentPacket = SystemTimer.currentTimeMillis();
    private long latestTimeOfReceivedByte = SystemTimer.currentTimeMillis();
    private long latestTimeOfSentByte = SystemTimer.currentTimeMillis();
    private long timeCreated = SystemTimer.currentTimeMillis();
    private Long timeFirstConnected = null;
    private long timeClosed = SystemTimer.currentTimeMillis();
    private long timeInReconnQueue = SystemTimer.currentTimeMillis();
    private AtomicLong sentBytes = new AtomicLong();
    private AtomicLong sentPackets = new AtomicLong();
    private AtomicLong handledBytes = new AtomicLong();
    private AtomicLong handledPackets = new AtomicLong();
    private AtomicLong handledPacketCosts = new AtomicLong();
    private AtomicLong receivedBytes = new AtomicLong();
    private AtomicLong receivedTcps = new AtomicLong();
    private AtomicLong receivedPackets = new AtomicLong();

    public double getBytesPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedBytes.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public double getPacketsPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedPackets.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public int getDecodeFailCount() {
        return this.decodeFailCount;
    }

    public AtomicLong getHandledBytes() {
        return this.handledBytes;
    }

    public AtomicLong getHandledPackets() {
        return this.handledPackets;
    }

    public long getLatestTimeOfReceivedPacket() {
        return this.latestTimeOfReceivedPacket;
    }

    public long getLatestTimeOfSentPacket() {
        return this.latestTimeOfSentPacket;
    }

    public AtomicLong getReceivedBytes() {
        return this.receivedBytes;
    }

    public AtomicLong getReceivedPackets() {
        return this.receivedPackets;
    }

    public AtomicLong getSentBytes() {
        return this.sentBytes;
    }

    public AtomicLong getSentPackets() {
        return this.sentPackets;
    }

    public long getTimeClosed() {
        return this.timeClosed;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public Long getTimeFirstConnected() {
        return this.timeFirstConnected;
    }

    public long getTimeInReconnQueue() {
        return this.timeInReconnQueue;
    }

    public void setDecodeFailCount(int decodeFailCount) {
        this.decodeFailCount = decodeFailCount;
    }

    public void setHandledBytes(AtomicLong countHandledByte) {
        this.handledBytes = countHandledByte;
    }

    public void setLatestTimeOfReceivedPacket(long latestTimeOfReceivedPacket) {
        this.latestTimeOfReceivedPacket = latestTimeOfReceivedPacket;
    }

    public void setLatestTimeOfSentPacket(long latestTimeOfSentPacket) {
        this.latestTimeOfSentPacket = latestTimeOfSentPacket;
    }

    public void setReceivedBytes(AtomicLong receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    public void setReceivedPackets(AtomicLong receivedPackets) {
        this.receivedPackets = receivedPackets;
    }

    public void setSentBytes(AtomicLong sentBytes) {
        this.sentBytes = sentBytes;
    }

    public void setSentPackets(AtomicLong sentPackets) {
        this.sentPackets = sentPackets;
    }

    public void setTimeClosed(long timeClosed) {
        this.timeClosed = timeClosed;
    }

    public void setTimeFirstConnected(Long timeFirstConnected) {
        this.timeFirstConnected = timeFirstConnected;
    }

    public void setTimeInReconnQueue(long timeInReconnQueue) {
        this.timeInReconnQueue = timeInReconnQueue;
    }

    public long getLatestTimeOfReceivedByte() {
        return this.latestTimeOfReceivedByte;
    }

    public void setLatestTimeOfReceivedByte(long latestTimeOfReceivedByte) {
        this.latestTimeOfReceivedByte = latestTimeOfReceivedByte;
    }

    public long getLatestTimeOfSentByte() {
        return this.latestTimeOfSentByte;
    }

    public void setLatestTimeOfSentByte(long latestTimeOfSentByte) {
        this.latestTimeOfSentByte = latestTimeOfSentByte;
    }

    public AtomicLong getReceivedTcps() {
        return this.receivedTcps;
    }

    public void setReceivedTcps(AtomicLong receivedTcps) {
        this.receivedTcps = receivedTcps;
    }

    public AtomicLong getHandledPacketCosts() {
        return this.handledPacketCosts;
    }

    public double getHandledCostsPerPacket() {
        if (this.handledPackets.get() > 0L) {
            return this.handledPacketCosts.get() / this.handledPackets.get();
        }
        return 0.0;
    }
}

