/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.format.DatePrinter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.tio.core.ChannelAction;
import org.tio.core.ChannelContext;
import org.tio.core.intf.ChannelTraceHandler;
import org.tio.core.intf.Packet;
import org.tio.utils.json.Json;

public class DefaultChannelTraceHandler
implements ChannelTraceHandler {
    private Logger clientTraceLog = LoggerFactory.getLogger((String)"tio-client-trace-log");

    @Override
    public void traceChannel(ChannelContext channelContext, ChannelAction channelAction, Packet packet, Map<String, Object> extmsg) {
        if (this.clientTraceLog.isInfoEnabled()) {
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            map.put("time", DateTime.now().toString((DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT));
            map.put("action", (Object)channelAction);
            map.put("c_id", channelContext.getId());
            map.put("c", channelContext.toString());
            MDC.put((String)"tio_client", (String)channelContext.getClientNodeTraceFilename());
            if (packet != null) {
                map.put("p_id", channelContext.getClientNode().getPort() + "_" + packet.getId());
                map.put("p_respId", packet.getRespId());
                map.put("packet", packet.logstr());
            }
            if (extmsg != null) {
                map.putAll(extmsg);
            }
            this.clientTraceLog.info(Json.toJson(map));
        }
    }
}

