/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelAction;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.PacketHandlerMode;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.Packet;
import org.tio.core.stat.ChannelStat;
import org.tio.core.stat.IpStat;
import org.tio.core.task.HandlerRunnable;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.utils.SystemTimer;

public class DecodeRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DecodeRunnable.class);
    private ChannelContext channelContext = null;
    private ByteBuffer lastByteBuffer = null;
    private ByteBuffer newByteBuffer = null;

    public static void handler(ChannelContext channelContext, Packet packet, int byteCount) {
        GroupContext groupContext = channelContext.getGroupContext();
        PacketHandlerMode packetHandlerMode = groupContext.getPacketHandlerMode();
        HandlerRunnable handlerRunnable = channelContext.getHandlerRunnable();
        if (packetHandlerMode == PacketHandlerMode.QUEUE) {
            handlerRunnable.addMsg(packet);
            groupContext.getTioExecutor().execute((Runnable)((Object)handlerRunnable));
        } else {
            handlerRunnable.handler(packet);
        }
    }

    public DecodeRunnable(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    public void clearMsgQueue() {
        this.lastByteBuffer = null;
        this.newByteBuffer = null;
    }

    @Override
    public void run() {
        ByteBuffer byteBuffer = this.newByteBuffer;
        if (byteBuffer != null) {
            if (this.lastByteBuffer != null) {
                byteBuffer = ByteBufferUtils.composite(this.lastByteBuffer, byteBuffer);
                this.lastByteBuffer = null;
            }
        } else {
            return;
        }
        try {
            while (true) {
                int len;
                int initPosition = byteBuffer.position();
                GroupContext groupContext = this.channelContext.getGroupContext();
                Packet packet = null;
                Integer packetNeededLength = this.channelContext.getPacketNeededLength();
                if (packetNeededLength != null) {
                    log.info("{}, \u89e3\u7801\u6240\u9700\u957f\u5ea6:{}", (Object)this.channelContext, (Object)packetNeededLength);
                    int readableLength = byteBuffer.limit() - initPosition;
                    if (readableLength >= packetNeededLength) {
                        packet = groupContext.getAioHandler().decode(byteBuffer, this.channelContext);
                    }
                } else {
                    packet = groupContext.getAioHandler().decode(byteBuffer, this.channelContext);
                }
                if (packet == null) {
                    this.lastByteBuffer = ByteBufferUtils.copy(byteBuffer, initPosition, byteBuffer.limit());
                    ChannelStat channelStat = this.channelContext.getStat();
                    int decodeFailCount = channelStat.getDecodeFailCount() + 1;
                    channelStat.setDecodeFailCount(decodeFailCount);
                    len = byteBuffer.limit() - initPosition;
                    log.info("{} \u89e3\u7801\u5931\u8d25, \u672c\u6b21\u5171\u5931\u8d25{}\u6b21\uff0c\u53c2\u4e0e\u89e3\u7801\u7684\u6570\u636e\u957f\u5ea6\u5171{}\u5b57\u8282", new Object[]{this.channelContext, decodeFailCount, len});
                    if (decodeFailCount > 5 && packetNeededLength == null) {
                        log.warn("{} \u89e3\u7801\u5931\u8d25, \u672c\u6b21\u5171\u5931\u8d25{}\u6b21\uff0c\u53c2\u4e0e\u89e3\u7801\u7684\u6570\u636e\u957f\u5ea6\u5171{}\u5b57\u8282\uff0c\u8bf7\u8003\u8651\u8981\u4e0d\u8981\u62c9\u9ed1\u8fd9\u4e2aip", new Object[]{this.channelContext, decodeFailCount, len});
                    }
                    return;
                }
                this.channelContext.setPacketNeededLength(null);
                this.channelContext.getStat().setLatestTimeOfReceivedPacket(SystemTimer.currentTimeMillis());
                ChannelStat channelStat = this.channelContext.getStat();
                channelStat.setDecodeFailCount(0);
                int afterDecodePosition = byteBuffer.position();
                len = afterDecodePosition - initPosition;
                this.channelContext.getGroupContext().getGroupStat().getReceivedPackets().incrementAndGet();
                this.channelContext.getStat().getReceivedPackets().incrementAndGet();
                List<Long> list = groupContext.ipStats.durationList;
                for (Long v : list) {
                    IpStat ipStat = groupContext.ipStats.get(v, this.channelContext.getClientNode().getIp());
                    ipStat.getReceivedPackets().incrementAndGet();
                }
                this.channelContext.traceClient(ChannelAction.RECEIVED, packet, null);
                packet.setByteCount(len);
                AioListener aioListener = this.channelContext.getGroupContext().getAioListener();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("{} \u6536\u5230\u6d88\u606f {}", (Object)this.channelContext, (Object)packet.logstr());
                    }
                    aioListener.onAfterReceived(this.channelContext, packet, len);
                }
                catch (Throwable e) {
                    log.error(e.toString(), e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("{}, \u89e3\u5305\u83b7\u5f97\u4e00\u4e2apacket:{}", (Object)this.channelContext, (Object)packet.logstr());
                }
                DecodeRunnable.handler(this.channelContext, packet, len);
                int remainingLength = byteBuffer.limit() - byteBuffer.position();
                if (remainingLength <= 0) break;
                if (!log.isDebugEnabled()) continue;
                log.debug("{},\u7ec4\u5305\u540e\uff0c\u8fd8\u5269\u6709\u6570\u636e:{}", (Object)this.channelContext, (Object)remainingLength);
            }
            this.lastByteBuffer = null;
            log.debug("{},\u7ec4\u5305\u540e\uff0c\u6570\u636e\u521a\u597d\u7528\u5b8c", (Object)this.channelContext);
            return;
        }
        catch (Throwable e) {
            this.channelContext.setPacketNeededLength(null);
            log.error((Object)((Object)this.channelContext) + ", " + byteBuffer + ", \u89e3\u7801\u5f02\u5e38:" + e.toString(), e);
            Aio.close(this.channelContext, e, "\u89e3\u7801\u5f02\u5e38:" + e.getMessage());
            if (e instanceof AioDecodeException) {
                GroupContext groupContext = this.channelContext.getGroupContext();
                List<Long> list = groupContext.ipStats.durationList;
                for (Long v : list) {
                    IpStat ipStat = groupContext.ipStats.get(v, this.channelContext.getClientNode().getIp());
                    ipStat.getDecodeErrorCount().incrementAndGet();
                }
            }
            return;
        }
    }

    public void setNewByteBuffer(ByteBuffer newByteBuffer) {
        this.newByteBuffer = newByteBuffer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.channelContext.toString();
    }
}

