/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.GroupListener;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.SetWithLock;

public class Groups {
    private static Logger log = LoggerFactory.getLogger(Groups.class);
    private MapWithLock<String, SetWithLock<ChannelContext>> groupmap = new MapWithLock(new ConcurrentHashMap());
    private MapWithLock<ChannelContext, SetWithLock<String>> channelmap = new MapWithLock(new ConcurrentHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String groupid, ChannelContext channelContext) {
        GroupContext groupContext = channelContext.getGroupContext();
        if (groupContext.isShortConnection()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)groupid)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock1 = this.groupmap.getLock().writeLock();
        SetWithLock channelContexts = null;
        try {
            lock1.lock();
            Map map = (Map)this.groupmap.getObj();
            channelContexts = (SetWithLock)map.get(groupid);
            if (channelContexts == null) {
                channelContexts = new SetWithLock(new HashSet());
                map.put(groupid, channelContexts);
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
        finally {
            lock1.unlock();
        }
        if (channelContexts != null) {
            ReentrantReadWriteLock.WriteLock lock11 = channelContexts.getLock().writeLock();
            try {
                lock11.lock();
                ((Set)channelContexts.getObj()).add(channelContext);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
            finally {
                lock11.unlock();
            }
        }
        ReentrantReadWriteLock.WriteLock lock2 = this.channelmap.getLock().writeLock();
        SetWithLock groups = null;
        try {
            lock2.lock();
            groups = (SetWithLock)((Map)this.channelmap.getObj()).get((Object)channelContext);
            if (groups == null) {
                groups = new SetWithLock(new HashSet());
            }
            ((Map)this.channelmap.getObj()).put(channelContext, groups);
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
        finally {
            lock2.unlock();
        }
        if (groups != null) {
            ReentrantReadWriteLock.WriteLock lock22 = groups.getLock().writeLock();
            try {
                lock22.lock();
                ((Set)groups.getObj()).add(groupid);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
            finally {
                lock22.unlock();
            }
        }
    }

    public SetWithLock<ChannelContext> clients(GroupContext groupContext, String groupid) {
        if (groupContext.isShortConnection()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)groupid)) {
            return null;
        }
        Map map = (Map)this.groupmap.getObj();
        SetWithLock set = (SetWithLock)map.get(groupid);
        return set;
    }

    public MapWithLock<ChannelContext, SetWithLock<String>> getChannelmap() {
        return this.channelmap;
    }

    public MapWithLock<String, SetWithLock<ChannelContext>> getGroupmap() {
        return this.groupmap;
    }

    public SetWithLock<String> groups(ChannelContext channelContext) {
        GroupContext groupContext = channelContext.getGroupContext();
        if (groupContext.isShortConnection()) {
            return null;
        }
        Map map = (Map)this.channelmap.getObj();
        SetWithLock set = (SetWithLock)map.get((Object)channelContext);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(ChannelContext channelContext) {
        GroupContext groupContext = channelContext.getGroupContext();
        if (groupContext.isShortConnection()) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.channelmap.getLock().writeLock();
        SetWithLock set = null;
        try {
            lock.lock();
            Map m = (Map)this.channelmap.getObj();
            set = (SetWithLock)m.get((Object)channelContext);
            m.remove((Object)channelContext);
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
        finally {
            lock.unlock();
        }
        if (set != null) {
            GroupListener groupListener = groupContext.getGroupListener();
            Set groups = (Set)set.getObj();
            if (groups != null && groups.size() > 0) {
                for (String groupid : groups) {
                    this.unbind(groupid, channelContext);
                    if (groupListener == null) continue;
                    try {
                        groupListener.onAfterUnbind(channelContext, groupid);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String groupid, ChannelContext channelContext) {
        GroupContext groupContext = channelContext.getGroupContext();
        if (groupContext.isShortConnection()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)groupid)) {
            return;
        }
        SetWithLock set = (SetWithLock)((Map)this.groupmap.getObj()).get(groupid);
        if (set != null) {
            ReentrantReadWriteLock.WriteLock lock1 = set.getLock().writeLock();
            try {
                lock1.lock();
                ((Set)set.getObj()).remove((Object)channelContext);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
            finally {
                lock1.unlock();
            }
            if (((Set)set.getObj()).size() == 0) {
                ReentrantReadWriteLock.WriteLock lock2 = this.groupmap.getLock().writeLock();
                try {
                    lock2.lock();
                    ((Map)this.groupmap.getObj()).remove(groupid);
                }
                catch (Throwable e) {
                    log.error(e.toString(), e);
                }
                finally {
                    lock2.unlock();
                }
            }
        }
    }
}

