/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.ChannelStat;
import org.tio.core.GroupContext;
import org.tio.core.ObjWithLock;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.Packet;
import org.tio.core.stat.GroupStat;
import org.tio.core.threadpool.DefaultThreadFactory;
import org.tio.core.utils.SystemTimer;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.DefaultServerAioListener;
import org.tio.server.ServerGroupStat;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;

public class ServerGroupContext<SessionContext, P extends Packet, R>
extends GroupContext<SessionContext, P, R> {
    static Logger log = LoggerFactory.getLogger(ServerGroupContext.class);
    private ThreadPoolExecutor groupExecutor = null;
    private AcceptCompletionHandler<SessionContext, P, R> acceptCompletionHandler = null;
    private ServerAioHandler<SessionContext, P, R> serverAioHandler = null;
    private ServerAioListener<SessionContext, P, R> serverAioListener = null;
    protected ServerGroupStat serverGroupStat = new ServerGroupStat();
    private Thread checkHeartbeatThread = null;

    public ServerGroupContext(ServerAioHandler<SessionContext, P, R> aioHandler, ServerAioListener<SessionContext, P, R> aioListener) {
        this(aioHandler, aioListener, new ThreadPoolExecutor(CORE_POOL_SIZE, CORE_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), DefaultThreadFactory.getInstance("t-aio-server-group")));
    }

    public ServerGroupContext(ServerAioHandler<SessionContext, P, R> serverAioHandler, ServerAioListener<SessionContext, P, R> serverAioListener, ThreadPoolExecutor groupExecutor) {
        this.groupExecutor = groupExecutor;
        this.acceptCompletionHandler = new AcceptCompletionHandler();
        this.setServerAioHandler(serverAioHandler);
        this.setServerAioListener(serverAioListener);
        this.checkHeartbeatThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                long sleeptime = ServerGroupContext.this.heartbeatTimeout;
                while (!ServerGroupContext.this.isStopped()) {
                    long iv;
                    ObjWithLock objwithlock;
                    long start = SystemTimer.currentTimeMillis();
                    ObjWithLock objWithLock = ServerGroupContext.this.getConnections().getSetWithLock();
                    Set set = null;
                    ReentrantReadWriteLock.ReadLock readLock = objWithLock.getLock().readLock();
                    long start1 = 0L;
                    int count = 0;
                    readLock.lock();
                    start1 = SystemTimer.currentTimeMillis();
                    set = objWithLock.getObj();
                    for (ChannelContext entry : set) {
                        ++count;
                        ChannelContext channelContext = entry;
                        ChannelStat stat = channelContext.getStat();
                        long timeLatestReceivedMsg = stat.getLatestTimeOfReceivedPacket();
                        long timeLatestSentMsg = stat.getLatestTimeOfSentPacket();
                        long compareTime = Math.max(timeLatestReceivedMsg, timeLatestSentMsg);
                        long currtime = SystemTimer.currentTimeMillis();
                        long interval = currtime - compareTime;
                        if (interval <= ServerGroupContext.this.heartbeatTimeout) continue;
                        log.warn("{}, {} ms\u6ca1\u6709\u6536\u53d1\u6d88\u606f", channelContext, (Object)interval);
                        Aio.remove(channelContext, interval + " ms\u6ca1\u6709\u6536\u53d1\u6d88\u606f");
                    }
                    try {
                        readLock.unlock();
                        if (log.isErrorEnabled()) {
                            int groups = 0;
                            objwithlock = ServerGroupContext.this.getGroups().clients("g");
                            if (objwithlock != null) {
                                groups = objwithlock.getObj().size();
                            }
                            log.error("[{}]:[{}]: \u5f53\u524d\u8fde\u63a5\u4e2a\u6570:{}, \u7fa4\u7ec4(g):{}, \u5171\u63a5\u53d7\u8fde\u63a5:{}, \u4e00\u5171\u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u4e2a\u6570:{}, \u5df2\u63a5\u6536\u6d88\u606f:({}p)({}b), \u5df2\u5904\u7406\u6d88\u606f:{}, \u5df2\u53d1\u9001\u6d88\u606f:({}p)({}b)", new Object[]{SystemTimer.currentTimeMillis(), ServerGroupContext.this.id, set.size(), groups, ServerGroupContext.this.serverGroupStat.getAccepted().get(), ServerGroupContext.this.serverGroupStat.getClosed().get(), ServerGroupContext.this.serverGroupStat.getReceivedPacket().get(), ServerGroupContext.this.serverGroupStat.getReceivedBytes().get(), ServerGroupContext.this.serverGroupStat.getHandledPacket().get(), ServerGroupContext.this.serverGroupStat.getSentPacket().get(), ServerGroupContext.this.serverGroupStat.getSentBytes().get()});
                        }
                        if (log.isErrorEnabled()) {
                            log.error("clientNodes:{},connections:{},connecteds:{},closeds:{},groups:[channelmap:{}, groupmap:{}],users:{},syns:{}", new Object[]{ServerGroupContext.this.clientNodes.getMap().getObj().size(), ServerGroupContext.this.connections.getSetWithLock().getObj().size(), ServerGroupContext.this.connecteds.getSetWithLock().getObj().size(), ServerGroupContext.this.closeds.getSetWithLock().getObj().size(), ServerGroupContext.this.groups.getChannelmap().getObj().size(), ServerGroupContext.this.groups.getGroupmap().getObj().size(), ServerGroupContext.this.users.getMap().getObj().size(), ServerGroupContext.this.syns.getMap().getObj().size()});
                        }
                        if (log.isErrorEnabled()) {
                            long end = SystemTimer.currentTimeMillis();
                            long iv1 = start1 - start;
                            iv = end - start1;
                            log.error("\u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u65f6\u95f4:{}", new Object[]{count, iv1, iv, ServerGroupContext.this.heartbeatTimeout});
                        }
                        Thread.sleep(sleeptime);
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                    continue;
                    catch (Throwable e) {
                        try {
                            log.error("", e);
                        }
                        catch (Throwable throwable) {
                            try {
                                readLock.unlock();
                                if (log.isErrorEnabled()) {
                                    int groups = 0;
                                    ObjWithLock objwithlock2 = ServerGroupContext.this.getGroups().clients("g");
                                    if (objwithlock2 != null) {
                                        groups = objwithlock2.getObj().size();
                                    }
                                    log.error("[{}]:[{}]: \u5f53\u524d\u8fde\u63a5\u4e2a\u6570:{}, \u7fa4\u7ec4(g):{}, \u5171\u63a5\u53d7\u8fde\u63a5:{}, \u4e00\u5171\u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u4e2a\u6570:{}, \u5df2\u63a5\u6536\u6d88\u606f:({}p)({}b), \u5df2\u5904\u7406\u6d88\u606f:{}, \u5df2\u53d1\u9001\u6d88\u606f:({}p)({}b)", new Object[]{SystemTimer.currentTimeMillis(), ServerGroupContext.this.id, set.size(), groups, ServerGroupContext.this.serverGroupStat.getAccepted().get(), ServerGroupContext.this.serverGroupStat.getClosed().get(), ServerGroupContext.this.serverGroupStat.getReceivedPacket().get(), ServerGroupContext.this.serverGroupStat.getReceivedBytes().get(), ServerGroupContext.this.serverGroupStat.getHandledPacket().get(), ServerGroupContext.this.serverGroupStat.getSentPacket().get(), ServerGroupContext.this.serverGroupStat.getSentBytes().get()});
                                }
                                if (log.isErrorEnabled()) {
                                    log.error("clientNodes:{},connections:{},connecteds:{},closeds:{},groups:[channelmap:{}, groupmap:{}],users:{},syns:{}", new Object[]{ServerGroupContext.this.clientNodes.getMap().getObj().size(), ServerGroupContext.this.connections.getSetWithLock().getObj().size(), ServerGroupContext.this.connecteds.getSetWithLock().getObj().size(), ServerGroupContext.this.closeds.getSetWithLock().getObj().size(), ServerGroupContext.this.groups.getChannelmap().getObj().size(), ServerGroupContext.this.groups.getGroupmap().getObj().size(), ServerGroupContext.this.users.getMap().getObj().size(), ServerGroupContext.this.syns.getMap().getObj().size()});
                                }
                                if (log.isErrorEnabled()) {
                                    long end = SystemTimer.currentTimeMillis();
                                    long iv1 = start1 - start;
                                    long iv2 = end - start1;
                                    log.error("\u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u65f6\u95f4:{}", new Object[]{count, iv1, iv2, ServerGroupContext.this.heartbeatTimeout});
                                }
                                Thread.sleep(sleeptime);
                            }
                            catch (Exception e2) {
                                log.error("", (Throwable)e2);
                            }
                            throw throwable;
                        }
                        try {
                            readLock.unlock();
                            if (log.isErrorEnabled()) {
                                int groups = 0;
                                objwithlock = ServerGroupContext.this.getGroups().clients("g");
                                if (objwithlock != null) {
                                    groups = objwithlock.getObj().size();
                                }
                                log.error("[{}]:[{}]: \u5f53\u524d\u8fde\u63a5\u4e2a\u6570:{}, \u7fa4\u7ec4(g):{}, \u5171\u63a5\u53d7\u8fde\u63a5:{}, \u4e00\u5171\u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u4e2a\u6570:{}, \u5df2\u63a5\u6536\u6d88\u606f:({}p)({}b), \u5df2\u5904\u7406\u6d88\u606f:{}, \u5df2\u53d1\u9001\u6d88\u606f:({}p)({}b)", new Object[]{SystemTimer.currentTimeMillis(), ServerGroupContext.this.id, set.size(), groups, ServerGroupContext.this.serverGroupStat.getAccepted().get(), ServerGroupContext.this.serverGroupStat.getClosed().get(), ServerGroupContext.this.serverGroupStat.getReceivedPacket().get(), ServerGroupContext.this.serverGroupStat.getReceivedBytes().get(), ServerGroupContext.this.serverGroupStat.getHandledPacket().get(), ServerGroupContext.this.serverGroupStat.getSentPacket().get(), ServerGroupContext.this.serverGroupStat.getSentBytes().get()});
                            }
                            if (log.isErrorEnabled()) {
                                log.error("clientNodes:{},connections:{},connecteds:{},closeds:{},groups:[channelmap:{}, groupmap:{}],users:{},syns:{}", new Object[]{ServerGroupContext.this.clientNodes.getMap().getObj().size(), ServerGroupContext.this.connections.getSetWithLock().getObj().size(), ServerGroupContext.this.connecteds.getSetWithLock().getObj().size(), ServerGroupContext.this.closeds.getSetWithLock().getObj().size(), ServerGroupContext.this.groups.getChannelmap().getObj().size(), ServerGroupContext.this.groups.getGroupmap().getObj().size(), ServerGroupContext.this.users.getMap().getObj().size(), ServerGroupContext.this.syns.getMap().getObj().size()});
                            }
                            if (log.isErrorEnabled()) {
                                long end = SystemTimer.currentTimeMillis();
                                long iv1 = start1 - start;
                                iv = end - start1;
                                log.error("\u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u65f6\u95f4:{}", new Object[]{count, iv1, iv, ServerGroupContext.this.heartbeatTimeout});
                            }
                            Thread.sleep(sleeptime);
                        }
                        catch (Exception e3) {
                            log.error("", (Throwable)e3);
                        }
                    }
                }
            }
        }, "t-aio-timer-checkheartbeat-" + this.id);
        this.checkHeartbeatThread.setDaemon(true);
        this.checkHeartbeatThread.setPriority(1);
        this.checkHeartbeatThread.start();
    }

    public ThreadPoolExecutor getGroupExecutor() {
        return this.groupExecutor;
    }

    public void setGroupExecutor(ThreadPoolExecutor groupExecutor) {
        this.groupExecutor = groupExecutor;
    }

    public ServerGroupStat getServerGroupStat() {
        return this.serverGroupStat;
    }

    public AcceptCompletionHandler<SessionContext, P, R> getAcceptCompletionHandler() {
        return this.acceptCompletionHandler;
    }

    public void setAcceptCompletionHandler(AcceptCompletionHandler<SessionContext, P, R> acceptCompletionHandler) {
        this.acceptCompletionHandler = acceptCompletionHandler;
    }

    public ServerAioHandler<SessionContext, P, R> getServerAioHandler() {
        return this.serverAioHandler;
    }

    public void setServerAioHandler(ServerAioHandler<SessionContext, P, R> serverAioHandler) {
        this.serverAioHandler = serverAioHandler;
    }

    public ServerAioListener<SessionContext, P, R> getServerAioListener() {
        return this.serverAioListener;
    }

    public void setServerAioListener(ServerAioListener<SessionContext, P, R> serverAioListener) {
        this.serverAioListener = serverAioListener;
        if (this.serverAioListener == null) {
            this.serverAioListener = new DefaultServerAioListener();
        }
    }

    @Override
    public AioHandler<SessionContext, P, R> getAioHandler() {
        return this.getServerAioHandler();
    }

    @Override
    public GroupStat getGroupStat() {
        return this.getServerGroupStat();
    }

    @Override
    public AioListener<SessionContext, P, R> getAioListener() {
        return this.getServerAioListener();
    }
}

