/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.utils;

import java.nio.channels.AsynchronousSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.intf.Packet;
import org.tio.core.task.HandlerRunnable;
import org.tio.core.task.SendRunnable;
import org.tio.core.threadpool.SynThreadPoolExecutor;
import org.tio.core.threadpool.intf.SynRunnableIntf;
import org.tio.core.utils.ThreadUtils;

public class AioUtils {
    private static Logger log = LoggerFactory.getLogger(AioUtils.class);

    public static <SessionContext, P extends Packet, R> boolean checkBeforeIO(ChannelContext<SessionContext, P, R> channelContext) {
        if (channelContext == null) {
            log.error("channelContext is null, {}", (Object)ThreadUtils.stackTrace());
            return false;
        }
        boolean isClosed = channelContext.isClosed();
        boolean isRemoved = channelContext.isRemoved();
        AsynchronousSocketChannel asynchronousSocketChannel = channelContext.getAsynchronousSocketChannel();
        Boolean isopen = null;
        if (asynchronousSocketChannel != null) {
            isopen = asynchronousSocketChannel.isOpen();
            if (isClosed || isRemoved) {
                if (isopen.booleanValue()) {
                    try {
                        Aio.close(channelContext, "asynchronousSocketChannel is open, but channelContext isClosed: " + isClosed + ", isRemoved: " + isRemoved);
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
                log.info("{}, isopen:{}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, isopen, channelContext.isClosed(), channelContext.isRemoved()});
                return false;
            }
        } else {
            log.error("{}, \u8bf7\u68c0\u67e5\u6b64\u5f02\u5e38, asynchronousSocketChannel is null, isClosed:{}, isRemoved:{}, {} ", new Object[]{channelContext, channelContext.isClosed(), channelContext.isRemoved(), ThreadUtils.stackTrace()});
            return false;
        }
        if (!isopen.booleanValue()) {
            log.info("{}, \u53ef\u80fd\u5bf9\u65b9\u5173\u95ed\u4e86\u8fde\u63a5, isopen:{}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, isopen, channelContext.isClosed(), channelContext.isRemoved()});
            Aio.close(channelContext, "asynchronousSocketChannel is not open, \u53ef\u80fd\u5bf9\u65b9\u5173\u95ed\u4e86\u8fde\u63a5");
            return false;
        }
        return true;
    }

    public static <SessionContext, P extends Packet, R> SendRunnable<SessionContext, P, R> selectSendRunnable(ChannelContext<SessionContext, P, R> channelContext, Packet packet) {
        return channelContext.getSendRunnableNormPrior();
    }

    public static <SessionContext, P extends Packet, R> SynThreadPoolExecutor<SynRunnableIntf> selectSendExecutor(ChannelContext<SessionContext, P, R> channelContext, Packet packet) {
        return channelContext.getGroupContext().getSendExecutorNormPrior();
    }

    public static <SessionContext, P extends Packet, R> HandlerRunnable<SessionContext, P, R> selectHandlerRunnable(ChannelContext<SessionContext, P, R> channelContext, Packet packet) {
        return channelContext.getHandlerRunnableNormPrior();
    }

    public static <SessionContext, P extends Packet, R> SynThreadPoolExecutor<SynRunnableIntf> selectHandlerExecutor(ChannelContext<SessionContext, P, R> channelContext, Packet packet) {
        return channelContext.getGroupContext().getHandlerExecutorNormPrior();
    }
}

