/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.threadpool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.tio.core.threadpool.DefaultRejectedExecutionHandler;
import org.tio.core.threadpool.DefaultThreadFactory;
import org.tio.core.threadpool.intf.SynRunnableIntf;

public class SynThreadPoolExecutor<T extends SynRunnableIntf>
extends ThreadPoolExecutor
implements Comparable<SynThreadPoolExecutor<T>> {
    public static final int CORE_POOL_NUM = 5;
    public static final int MAX_POOL_NUM = 40;
    public static final int KEEP_ALIVE_TIME = 90;
    public static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    public static final SynchronousQueue<Runnable> RUNNABLE_QUEUE = new SynchronousQueue();
    private String name = null;

    public SynThreadPoolExecutor(String name) {
        this(5, 40, 90L, RUNNABLE_QUEUE, DefaultThreadFactory.getInstance(name, null), name);
    }

    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, String name) {
        this(corePoolSize, maximumPoolSize, 90L, RUNNABLE_QUEUE, DefaultThreadFactory.getInstance(name, null), name);
    }

    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> runnableQueue, String name) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, runnableQueue, DefaultThreadFactory.getInstance(name, null), name);
    }

    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> runnableQueue, RejectedExecutionHandler handler, String name) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, runnableQueue, DefaultThreadFactory.getInstance(name, null), handler, name);
    }

    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> runnableQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, String name) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TIME_UNIT, runnableQueue, threadFactory, handler);
        this.name = name;
    }

    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> runnableQueue, ThreadFactory threadFactory, String name) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TIME_UNIT, runnableQueue, threadFactory);
        this.name = name;
        DefaultRejectedExecutionHandler handler = new DefaultRejectedExecutionHandler(this);
        this.setRejectedExecutionHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkBeforeExecute(T runnable) {
        ReadWriteLock runningLock = runnable.runningLock();
        Lock writeLock = runningLock.writeLock();
        boolean tryLock = false;
        try {
            boolean bl = tryLock = writeLock.tryLock();
            return bl;
        }
        finally {
            if (tryLock) {
                writeLock.unlock();
            }
        }
    }

    @Override
    public void execute(Runnable _runnable) {
        SynRunnableIntf runnable = (SynRunnableIntf)_runnable;
        if (this.checkBeforeExecute(runnable)) {
            super.execute(runnable);
        }
    }

    public <R> Future<R> submit(Runnable _runnable, R result) {
        SynRunnableIntf runnable = (SynRunnableIntf)_runnable;
        if (this.checkBeforeExecute(runnable)) {
            Future<R> ret = super.submit(runnable, result);
            return ret;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(SynThreadPoolExecutor<T> o) {
        if (o.getCompletedTaskCount() > this.getCompletedTaskCount()) {
            return -1;
        }
        if (o.getCompletedTaskCount() < this.getCompletedTaskCount()) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }
}

