/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.threadpool;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.threadpool.SynThreadPoolExecutor;
import org.tio.core.threadpool.intf.SynRunnableIntf;

public class DefaultRejectedExecutionHandler<R extends SynRunnableIntf>
implements RejectedExecutionHandler {
    private static Logger log = LoggerFactory.getLogger(DefaultRejectedExecutionHandler.class);
    private static AtomicInteger timerSeq = new AtomicInteger();
    private AtomicLong rejectedCount = new AtomicLong();
    private Thread submitTaskThread;
    private SubmitTaskRunnable<R> submitTaskRunnable;

    public DefaultRejectedExecutionHandler(SynThreadPoolExecutor<SynRunnableIntf> synThreadPoolExecutor) {
        String threadname = synThreadPoolExecutor.getName() + "-rejected-handler-" + timerSeq.incrementAndGet();
        LinkedBlockingDeque<SynRunnableIntf> deque = new LinkedBlockingDeque<SynRunnableIntf>();
        this.submitTaskRunnable = new SubmitTaskRunnable(deque, synThreadPoolExecutor);
        this.submitTaskThread = new Thread(this.submitTaskRunnable, threadname);
        this.submitTaskThread.start();
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        SynRunnableIntf rr = null;
        if (!(r instanceof SynRunnableIntf)) {
            log.error("\u53ea\u652f\u6301SynRunnableIntf");
            return;
        }
        rr = (SynRunnableIntf)r;
        if (rr.isCanceled()) {
            log.error("\u4efb\u52a1\u5df2\u7ecf\u53d6\u6d88");
            return;
        }
        this.rejectedCount.incrementAndGet();
        LinkedBlockingDeque<SynRunnableIntf> deque = this.submitTaskRunnable.deque;
        if (deque.contains(r)) {
            log.debug("{} has contained in deque, deque size is {}", (Object)r, (Object)deque.size());
        } else if (this.submitTaskThread == Thread.currentThread()) {
            log.debug("thread is same--submitTaskThread:{}, currentThread:{}", (Object)this.submitTaskThread, (Object)Thread.currentThread());
            deque.addFirst(rr);
        } else {
            log.debug("thread is diff--submitTaskThread:{}, currentThread:{}", (Object)this.submitTaskThread, (Object)Thread.currentThread());
            deque.addLast(rr);
        }
        log.debug("{} is rejected, {} tasks is waiting!", (Object)r, (Object)deque.size());
    }

    public Thread getSubmitTaskThread() {
        return this.submitTaskThread;
    }

    public void setSubmitTaskThread(Thread submitTaskThread) {
        this.submitTaskThread = submitTaskThread;
    }

    public SubmitTaskRunnable<R> getSubmitTaskRunnable() {
        return this.submitTaskRunnable;
    }

    public void setSubmitTaskRunnable(SubmitTaskRunnable<R> submitTaskRunnable) {
        this.submitTaskRunnable = submitTaskRunnable;
    }

    public AtomicLong getRejectedCount() {
        return this.rejectedCount;
    }

    public void setRejectedCount(AtomicLong rejectedCount) {
        this.rejectedCount = rejectedCount;
    }

    public static class SubmitTaskRunnable<R extends SynRunnableIntf>
    implements Runnable {
        LinkedBlockingDeque<SynRunnableIntf> deque = null;
        SynThreadPoolExecutor<SynRunnableIntf> executor = null;

        public SubmitTaskRunnable(LinkedBlockingDeque<SynRunnableIntf> deque, SynThreadPoolExecutor<SynRunnableIntf> executor) {
            this.deque = deque;
            this.executor = executor;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Runnable r = this.deque.take();
                        this.executor.execute(r);
                        log.debug("submit a runnable, {} runnables waiting for submit", (Object)this.deque.size());
                    }
                }
                catch (Throwable e) {
                    log.error(e.toString(), e);
                    continue;
                }
                break;
            }
        }

        public LinkedBlockingDeque<SynRunnableIntf> getDeque() {
            return this.deque;
        }

        public void setDeque(LinkedBlockingDeque<SynRunnableIntf> deque) {
            this.deque = deque;
        }
    }
}

