/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.threadpool;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.threadpool.AbstractSynRunnable;
import org.tio.core.threadpool.intf.QueueRunnableIntf;

public abstract class AbstractQueueRunnable<T>
extends AbstractSynRunnable
implements QueueRunnableIntf<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueueRunnable.class);
    protected ConcurrentLinkedQueue<T> msgQueue = new ConcurrentLinkedQueue();

    public AbstractQueueRunnable(Executor executor) {
        super(executor);
    }

    @Override
    public boolean isNeededExecute() {
        return this.msgQueue.size() > 0;
    }

    public void addMsg(T t) {
        if (this.isCanceled()) {
            log.error("\u4efb\u52a1\u5df2\u7ecf\u53d6\u6d88");
            return;
        }
        this.getMsgQueue().add(t);
    }

    @Override
    public ConcurrentLinkedQueue<T> getMsgQueue() {
        return this.msgQueue;
    }

    public void setMsgQueue(ConcurrentLinkedQueue<T> msgQueue) {
        this.msgQueue = msgQueue;
    }
}

