/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.WriteCompletionHandler;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.Packet;
import org.tio.core.threadpool.AbstractQueueRunnable;
import org.tio.core.utils.AioUtils;
import org.tio.core.utils.SystemTimer;

public class SendRunnable<SessionContext, P extends Packet, R>
extends AbstractQueueRunnable<P> {
    private static final Logger log = LoggerFactory.getLogger(SendRunnable.class);
    private ChannelContext<SessionContext, P, R> channelContext = null;

    public SendRunnable(ChannelContext<SessionContext, P, R> channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
    }

    public void clearMsgQueue() {
        this.msgQueue.clear();
    }

    public void sendPacket(P packet) {
        GroupContext<SessionContext, P, R> groupContext = this.channelContext.getGroupContext();
        ByteBuffer byteBuffer = this.getByteBuffer(packet, groupContext, groupContext.getAioHandler());
        int packetCount = 1;
        this.sendByteBuffer(byteBuffer, packetCount, packet);
    }

    public void sendByteBuffer(ByteBuffer byteBuffer, Integer packetCount, Object packets) {
        if (byteBuffer == null) {
            log.error("{},byteBuffer is null", this.channelContext);
            return;
        }
        if (!AioUtils.checkBeforeIO(this.channelContext)) {
            return;
        }
        byteBuffer.flip();
        AsynchronousSocketChannel asynchronousSocketChannel = this.channelContext.getAsynchronousSocketChannel();
        WriteCompletionHandler<SessionContext, P, R> writeCompletionHandler = this.channelContext.getWriteCompletionHandler();
        try {
            writeCompletionHandler.getWriteSemaphore().acquire();
        }
        catch (InterruptedException e) {
            log.error(e.toString(), (Throwable)e);
        }
        asynchronousSocketChannel.write(byteBuffer, packets, writeCompletionHandler);
        this.channelContext.getStat().setLatestTimeOfSentPacket(SystemTimer.currentTimeMillis());
    }

    public void setChannelContext(ChannelContext<SessionContext, P, R> channelContext) {
        this.channelContext = channelContext;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(":");
        builder.append(this.channelContext.toString());
        return builder.toString();
    }

    @Override
    public void runTask() {
        int queueSize = this.msgQueue.size();
        if (queueSize == 0) {
            return;
        }
        if (queueSize >= 2000) {
            queueSize = 1000;
        }
        Packet packet = null;
        GroupContext<SessionContext, P, R> groupContext = this.channelContext.getGroupContext();
        AioHandler<SessionContext, P, R> aioHandler = groupContext.getAioHandler();
        if (queueSize > 1) {
            ByteBuffer[] byteBuffers = new ByteBuffer[queueSize];
            int allBytebufferCapacity = 0;
            int packetCount = 0;
            ArrayList<Packet> packets = new ArrayList<Packet>();
            for (int i = 0; i < queueSize && (packet = (Packet)this.msgQueue.poll()) != null; ++i) {
                ByteBuffer byteBuffer = this.getByteBuffer(packet, groupContext, aioHandler);
                log.info("{}, \u51c6\u5907\u53d1\u9001:{}", this.channelContext, (Object)packet.logstr());
                packets.add(packet);
                allBytebufferCapacity += byteBuffer.limit();
                ++packetCount;
                byteBuffers[i] = byteBuffer;
            }
            ByteBuffer allByteBuffer = ByteBuffer.allocate(allBytebufferCapacity);
            byte[] dest = allByteBuffer.array();
            for (ByteBuffer byteBuffer : byteBuffers) {
                if (byteBuffer == null) continue;
                int length = byteBuffer.limit();
                int position = allByteBuffer.position();
                System.arraycopy(byteBuffer.array(), 0, dest, position, length);
                allByteBuffer.position(position + length);
            }
            this.sendByteBuffer(allByteBuffer, packetCount, packets);
        } else {
            packet = (Packet)this.msgQueue.poll();
            if (packet != null) {
                log.info("{}, \u51c6\u5907\u53d1\u9001:{}", this.channelContext, (Object)packet.logstr());
                this.sendPacket(packet);
            }
        }
    }

    private ByteBuffer getByteBuffer(P packet, GroupContext<SessionContext, P, R> groupContext, AioHandler<SessionContext, P, R> aioHandler) {
        ByteBuffer byteBuffer = ((Packet)packet).getPreEncodedByteBuffer();
        byteBuffer = byteBuffer != null ? byteBuffer.duplicate() : aioHandler.encode(packet, groupContext, this.channelContext);
        return byteBuffer;
    }
}

