/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.Packet;
import org.tio.core.maintain.ChannelContextMapWithLock;
import org.tio.core.threadpool.AbstractQueueRunnable;

public class HandlerRunnable<SessionContext, P extends Packet, R>
extends AbstractQueueRunnable<P> {
    private static final Logger log = LoggerFactory.getLogger(HandlerRunnable.class);
    private ChannelContext<SessionContext, P, R> channelContext = null;
    private AtomicLong synFailCount = new AtomicLong();

    public HandlerRunnable(ChannelContext<SessionContext, P, R> channelContext, Executor executor) {
        super(executor);
        this.setChannelContext(channelContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handler(P packet) {
        int ret;
        block9: {
            ret = 0;
            try {
                GroupContext<SessionContext, P, R> groupContext = this.channelContext.getGroupContext();
                Integer synSeq = ((Packet)packet).getSynSeq();
                if (synSeq != null && synSeq > 0) {
                    ChannelContextMapWithLock<SessionContext, P, R> syns = this.channelContext.getGroupContext().getSyns();
                    P initPacket = syns.remove(synSeq);
                    if (initPacket != null) {
                        P p = initPacket;
                        synchronized (p) {
                            syns.put(synSeq, packet);
                            initPacket.notify();
                        }
                        groupContext.getGroupStat().getHandledPacket().incrementAndGet();
                        break block9;
                    }
                    log.error("[{}]\u540c\u6b65\u6d88\u606f\u5931\u8d25, synSeq is {}, \u4f46\u662f\u540c\u6b65\u96c6\u5408\u4e2d\u6ca1\u6709\u5bf9\u5e94key\u503c", (Object)this.synFailCount.incrementAndGet(), (Object)synSeq);
                    break block9;
                }
                groupContext.getAioHandler().handler(packet, this.channelContext);
                groupContext.getGroupStat().getHandledPacket().incrementAndGet();
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
                int n = ret;
                return n;
            }
        }
        return ++ret;
    }

    public void clearMsgQueue() {
        this.msgQueue.clear();
    }

    public ChannelContext<SessionContext, P, R> getChannelContext() {
        return this.channelContext;
    }

    public void setChannelContext(ChannelContext<SessionContext, P, R> channelContext) {
        this.channelContext = channelContext;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(":");
        builder.append(this.channelContext.toString());
        return builder.toString();
    }

    @Override
    public void runTask() {
        Packet packet = null;
        while ((packet = (Packet)this.msgQueue.poll()) != null) {
            this.handler(packet);
        }
    }
}

