/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.PacketHandlerMode;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.Packet;
import org.tio.core.task.HandlerRunnable;
import org.tio.core.threadpool.SynThreadPoolExecutor;
import org.tio.core.threadpool.intf.SynRunnableIntf;
import org.tio.core.utils.AioUtils;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.core.utils.SystemTimer;
import org.tio.core.utils.ThreadUtils;

public class DecodeRunnable<SessionContext, P extends Packet, R>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DecodeRunnable.class);
    private ChannelContext<SessionContext, P, R> channelContext = null;
    private ByteBuffer lastByteBuffer = null;
    private ByteBuffer newByteBuffer = null;

    public DecodeRunnable(ChannelContext<SessionContext, P, R> channelContext) {
        this.channelContext = channelContext;
    }

    public void clearMsgQueue() {
        this.lastByteBuffer = null;
        this.newByteBuffer = null;
    }

    public static <SessionContext, P extends Packet, R> void handler(ChannelContext<SessionContext, P, R> channelContext, P packet, int byteCount) {
        if (channelContext.isClosed() || channelContext.isRemoved()) {
            log.error("{}, closed:{}, removed:{}, packet:{}, stack:{}", new Object[]{channelContext, channelContext.isClosed(), channelContext.isRemoved(), packet.logstr(), ThreadUtils.stackTrace()});
            return;
        }
        GroupContext<SessionContext, P, R> groupContext = channelContext.getGroupContext();
        PacketHandlerMode packetHandlerMode = groupContext.getPacketHandlerMode();
        HandlerRunnable<SessionContext, P, R> handlerRunnable = AioUtils.selectHandlerRunnable(channelContext, packet);
        if (packetHandlerMode == PacketHandlerMode.QUEUE) {
            handlerRunnable.addMsg(packet);
            SynThreadPoolExecutor<SynRunnableIntf> synThreadPoolExecutor = AioUtils.selectHandlerExecutor(channelContext, packet);
            synThreadPoolExecutor.execute(handlerRunnable);
        } else {
            handlerRunnable.handler(packet);
        }
    }

    public ChannelContext<SessionContext, P, R> getChannelContext() {
        return this.channelContext;
    }

    public void setChannelContext(ChannelContext<SessionContext, P, R> channelContext) {
        this.channelContext = channelContext;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(":");
        builder.append(this.channelContext.toString());
        return builder.toString();
    }

    @Override
    public void run() {
        ByteBuffer byteBuffer = this.newByteBuffer;
        if (byteBuffer != null) {
            if (this.lastByteBuffer != null) {
                byteBuffer = ByteBufferUtils.composite(this.lastByteBuffer, byteBuffer);
                this.lastByteBuffer = null;
            }
        } else {
            return;
        }
        try {
            while (true) {
                int initPosition = byteBuffer.position();
                P packet = this.channelContext.getGroupContext().getAioHandler().decode(byteBuffer, this.channelContext);
                if (packet == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("{},\u6570\u636e\u4e0d\u591f\uff0c\u7ec4\u4e0d\u4e86\u5305", (Object)this.channelContext.toString());
                    }
                    this.lastByteBuffer = ByteBufferUtils.copy(byteBuffer, initPosition, byteBuffer.limit());
                    return;
                }
                this.channelContext.getStat().setLatestTimeOfReceivedPacket(SystemTimer.currentTimeMillis());
                int afterDecodePosition = byteBuffer.position();
                int len = afterDecodePosition - initPosition;
                if (len == 0) {
                    String logstr = this.channelContext + "\u89e3\u7801\u6210\u529f, " + ((Packet)packet).logstr() + "," + byteBuffer + " \u4f46\u662f\u5374\u53ea\u6d88\u8017\u4e860\u5b57\u8282, \u8fd9\u6709\u53ef\u80fd\u4f1a\u5bfc\u81f4\u6b7b\u5faa\u73af. " + ThreadUtils.stackTrace();
                    log.error(logstr);
                }
                this.channelContext.getGroupContext().getGroupStat().getReceivedPacket().incrementAndGet();
                this.channelContext.getGroupContext().getGroupStat().getReceivedBytes().addAndGet(len);
                DecodeRunnable.handler(this.channelContext, packet, len);
                AioListener<SessionContext, P, R> aioListener = this.channelContext.getGroupContext().getAioListener();
                try {
                    log.info("{} \u6536\u5230:{}", this.channelContext, (Object)((Packet)packet).logstr());
                    aioListener.onAfterReceived(this.channelContext, packet, len);
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
                int remainingLength = byteBuffer.limit() - byteBuffer.position();
                if (remainingLength <= 0) break;
                if (!log.isDebugEnabled()) continue;
                log.debug("{},\u7ec4\u5305\u540e\uff0c\u8fd8\u5269\u6709\u6570\u636e:{}", this.channelContext, (Object)remainingLength);
            }
            this.lastByteBuffer = null;
            log.debug("{},\u7ec4\u5305\u540e\uff0c\u6570\u636e\u521a\u597d\u7528\u5b8c", this.channelContext);
            return;
        }
        catch (AioDecodeException e) {
            log.error(this.channelContext.toString() + "\u89e3\u7801\u5f02\u5e38", (Throwable)e);
            Aio.close(this.channelContext, e, "\u89e3\u7801\u5f02\u5e38:" + e.getMessage());
            return;
        }
    }

    public void setNewByteBuffer(ByteBuffer newByteBuffer) {
        this.newByteBuffer = newByteBuffer;
    }
}

