/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.syn;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tio.core.ObjWithLock;

public class ReadWriteMap<K, V>
implements Map<K, V> {
    private ObjWithLock<Map<K, V>> objWithLock = null;
    private Map<K, V> map = null;
    private ReentrantReadWriteLock readWriteLock = null;
    private ReentrantReadWriteLock.WriteLock writeLock = null;
    private ReentrantReadWriteLock.ReadLock readLock = null;

    public ReadWriteMap(Map<K, V> map) {
        if (map == null) {
            throw new RuntimeException("map \u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.map = map;
        this.objWithLock = new ObjWithLock<Map<K, V>>(this.map);
        this.readWriteLock = this.objWithLock.getLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.readLock = this.readWriteLock.readLock();
    }

    @Override
    public int size() {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        try {
            lock.lock();
            int n = this.map.size();
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        try {
            lock.lock();
            boolean bl = this.map.isEmpty();
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        try {
            lock.lock();
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        try {
            lock.lock();
            boolean bl = this.map.containsValue(value);
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public V get(Object key) {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        try {
            lock.lock();
            V v = this.map.get(key);
            return v;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public V put(K key, V value) {
        ReentrantReadWriteLock.WriteLock lock = this.writeLock;
        try {
            lock.lock();
            V v = this.map.put(key, value);
            return v;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        ReentrantReadWriteLock.WriteLock lock = this.writeLock;
        try {
            lock.lock();
            V v = this.map.remove(key);
            return v;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        ReentrantReadWriteLock.WriteLock lock = this.writeLock;
        try {
            lock.lock();
            this.map.putAll(m);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantReadWriteLock.WriteLock lock = this.writeLock;
        try {
            lock.lock();
            this.map.clear();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        try {
            lock.lock();
            Set<K> set = this.map.keySet();
            return set;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        try {
            lock.lock();
            Collection<V> collection = this.map.values();
            return collection;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        try {
            lock.lock();
            Set<Map.Entry<K, V>> set = this.map.entrySet();
            return set;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }
}

