/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ObjWithLock;
import org.tio.core.intf.Packet;

public class Groups<SessionContext, P extends Packet, R> {
    private static Logger log = LoggerFactory.getLogger(Groups.class);
    private ObjWithLock<Map<String, ObjWithLock<Set<ChannelContext<SessionContext, P, R>>>>> groupmap = new ObjWithLock(new ConcurrentHashMap());
    private ObjWithLock<Map<ChannelContext<SessionContext, P, R>, ObjWithLock<Set<String>>>> channelmap = new ObjWithLock(new ConcurrentHashMap());

    public ObjWithLock<Map<String, ObjWithLock<Set<ChannelContext<SessionContext, P, R>>>>> getGroupmap() {
        return this.groupmap;
    }

    public ObjWithLock<Map<ChannelContext<SessionContext, P, R>, ObjWithLock<Set<String>>>> getChannelmap() {
        return this.channelmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(ChannelContext<SessionContext, P, R> channelContext) {
        Set<String> groups;
        ReentrantReadWriteLock.WriteLock lock = this.channelmap.getLock().writeLock();
        ObjWithLock<Set<String>> set = null;
        try {
            lock.lock();
            Map<ChannelContext<SessionContext, P, R>, ObjWithLock<Set<String>>> m = this.channelmap.getObj();
            set = m.get(channelContext);
            m.remove(channelContext);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        if (set != null && (groups = set.getObj()) != null && groups.size() > 0) {
            for (String groupid : groups) {
                this.unbind(groupid, channelContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String groupid, ChannelContext<SessionContext, P, R> channelContext) {
        ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> set = this.groupmap.getObj().get(groupid);
        if (set != null) {
            ReentrantReadWriteLock.WriteLock lock1 = set.getLock().writeLock();
            try {
                lock1.lock();
                set.getObj().remove(channelContext);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            finally {
                lock1.unlock();
            }
            if (set.getObj().size() == 0) {
                ReentrantReadWriteLock.WriteLock lock2 = this.groupmap.getLock().writeLock();
                try {
                    lock2.lock();
                    this.groupmap.getObj().remove(groupid);
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
                finally {
                    lock2.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String groupid, ChannelContext<SessionContext, P, R> channelContext) {
        ReentrantReadWriteLock.WriteLock lock1 = this.groupmap.getLock().writeLock();
        ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> channelContexts = null;
        try {
            lock1.lock();
            channelContexts = this.groupmap.getObj().get(groupid);
            if (channelContexts == null) {
                channelContexts = new ObjWithLock(new HashSet());
            }
            this.groupmap.getObj().put(groupid, channelContexts);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            lock1.unlock();
        }
        if (channelContexts != null) {
            ReentrantReadWriteLock.WriteLock lock11 = channelContexts.getLock().writeLock();
            try {
                lock11.lock();
                channelContexts.getObj().add(channelContext);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            finally {
                lock11.unlock();
            }
        }
        ReentrantReadWriteLock.WriteLock lock2 = this.channelmap.getLock().writeLock();
        ObjWithLock<Set<String>> groups = null;
        try {
            lock2.lock();
            groups = this.channelmap.getObj().get(channelContext);
            if (groups == null) {
                groups = new ObjWithLock(new HashSet());
            }
            this.channelmap.getObj().put(channelContext, groups);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            lock2.unlock();
        }
        if (groups != null) {
            ReentrantReadWriteLock.WriteLock lock22 = groups.getLock().writeLock();
            try {
                lock22.lock();
                groups.getObj().add(groupid);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            finally {
                lock22.unlock();
            }
        }
    }

    public ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> clients(String groupid) {
        ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> set = this.groupmap.getObj().get(groupid);
        return set;
    }

    public ObjWithLock<Set<String>> groups(ChannelContext<SessionContext, P, R> channelContext) {
        ObjWithLock<Set<String>> set = this.channelmap.getObj().get(channelContext);
        return set;
    }
}

