/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.channels.CompletionHandler;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.Packet;
import org.tio.core.stat.GroupStat;

public class WriteCompletionHandler<SessionContext, P extends Packet, R>
implements CompletionHandler<Integer, Object> {
    private static Logger log = LoggerFactory.getLogger(WriteCompletionHandler.class);
    private ChannelContext<SessionContext, P, R> channelContext = null;
    private Semaphore writeSemaphore = new Semaphore(1);

    public WriteCompletionHandler(ChannelContext<SessionContext, P, R> channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public void completed(Integer result, Object packets) {
        boolean isSentSuccess;
        this.writeSemaphore.release();
        GroupContext<SessionContext, P, R> groupContext = this.channelContext.getGroupContext();
        GroupStat groupStat = groupContext.getGroupStat();
        AioListener<SessionContext, Packet, R> aioListener = groupContext.getAioListener();
        boolean bl = isSentSuccess = result > 0;
        if (isSentSuccess) {
            groupStat.getSentBytes().addAndGet(result.intValue());
        }
        int packetCount = 0;
        if (packets instanceof Packet) {
            Packet packet = (Packet)packets;
            if (isSentSuccess) {
                packetCount = 1;
                groupStat.getSentPacket().addAndGet(packetCount);
            }
            try {
                log.info("{} \u5df2\u7ecf\u53d1\u9001:{}", this.channelContext, (Object)packet.logstr());
                aioListener.onAfterSent(this.channelContext, packet, isSentSuccess);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        } else {
            List ps = (List)packets;
            if (isSentSuccess) {
                packetCount = ps.size();
                groupStat.getSentPacket().addAndGet(packetCount);
            }
            for (Packet p : ps) {
                try {
                    log.info("{} \u5df2\u7ecf\u53d1\u9001:{}", this.channelContext, (Object)p.logstr());
                    aioListener.onAfterSent(this.channelContext, p, isSentSuccess);
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
        if (!isSentSuccess) {
            log.error("\u53d1\u9001\u957f\u5ea6\u4e3a{}", (Object)result);
            Aio.close(this.channelContext, "\u5199\u6570\u636e\u8fd4\u56de:" + result);
        }
    }

    @Override
    public void failed(Throwable exc, Object packets) {
        try {
            this.writeSemaphore.release();
        }
        finally {
            Aio.close(this.channelContext, exc, "\u5199\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38");
        }
    }

    public ChannelContext<SessionContext, P, R> getChannelContext() {
        return this.channelContext;
    }

    public Semaphore getWriteSemaphore() {
        return this.writeSemaphore;
    }
}

