/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.intf.Packet;
import org.tio.core.task.DecodeRunnable;
import org.tio.core.utils.AioUtils;

public class ReadCompletionHandler<SessionContext, P extends Packet, R>
implements CompletionHandler<Integer, ByteBuffer> {
    private static Logger log = LoggerFactory.getLogger(ReadCompletionHandler.class);
    private ChannelContext<SessionContext, P, R> channelContext = null;
    private ByteBuffer readByteBuffer;

    public ReadCompletionHandler(ChannelContext<SessionContext, P, R> channelContext) {
        this.setChannelContext(channelContext);
        this.readByteBuffer = ByteBuffer.allocate(channelContext.getGroupContext().getReadBufferSize());
    }

    @Override
    public void completed(Integer result, ByteBuffer byteBuffer) {
        if (result > 0) {
            DecodeRunnable<SessionContext, P, R> decodeRunnable = this.channelContext.getDecodeRunnable();
            this.readByteBuffer.flip();
            decodeRunnable.setNewByteBuffer(this.readByteBuffer);
            decodeRunnable.run();
        } else if (result == 0) {
            log.error("{}\u8bfb\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e3a0", this.channelContext);
        } else if (result < 0) {
            Aio.close(this.channelContext, null, "\u8bfb\u6570\u636e\u65f6\u8fd4\u56de" + result);
        }
        if (AioUtils.checkBeforeIO(this.channelContext)) {
            AsynchronousSocketChannel asynchronousSocketChannel = this.channelContext.getAsynchronousSocketChannel();
            this.readByteBuffer.position(0);
            this.readByteBuffer.limit(this.readByteBuffer.capacity());
            asynchronousSocketChannel.read(this.readByteBuffer, this.readByteBuffer, this);
        }
    }

    @Override
    public void failed(Throwable exc, ByteBuffer byteBuffer) {
        Aio.close(this.channelContext, exc, "\u8bfb\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38");
    }

    public ChannelContext<SessionContext, P, R> getChannelContext() {
        return this.channelContext;
    }

    public void setChannelContext(ChannelContext<SessionContext, P, R> channelContext) {
        this.channelContext = channelContext;
    }

    public ByteBuffer getReadByteBuffer() {
        return this.readByteBuffer;
    }
}

