/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteOrder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ReconnConf;
import org.tio.core.PacketHandlerMode;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.Packet;
import org.tio.core.maintain.ChannelContextMapWithLock;
import org.tio.core.maintain.ChannelContextSetWithLock;
import org.tio.core.maintain.ClientNodes;
import org.tio.core.maintain.Groups;
import org.tio.core.maintain.Users;
import org.tio.core.stat.GroupStat;
import org.tio.core.threadpool.DefaultThreadFactory;
import org.tio.core.threadpool.SynThreadPoolExecutor;
import org.tio.core.threadpool.intf.SynRunnableIntf;

public abstract class GroupContext<SessionContext, P extends Packet, R> {
    static Logger log = LoggerFactory.getLogger(GroupContext.class);
    public static final int CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 1;
    public static final long DEFAULT_HEARTBEAT_TIMEOUT = 120000L;
    public static final int READ_BUFFER_SIZE = Integer.getInteger("tio.default.read.buffer.size", 2048);
    public static final long KEEP_ALIVE_TIME = 9000000L;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected long heartbeatTimeout = 120000L;
    private PacketHandlerMode packetHandlerMode = PacketHandlerMode.SINGLE_THREAD;
    protected int readBufferSize = READ_BUFFER_SIZE;
    protected ReconnConf<SessionContext, P, R> reconnConf;
    private SynThreadPoolExecutor<SynRunnableIntf> handlerExecutorNormPrior = null;
    private SynThreadPoolExecutor<SynRunnableIntf> sendExecutorNormPrior = null;
    private ThreadPoolExecutor closePoolExecutor = null;
    protected ClientNodes<SessionContext, P, R> clientNodes = new ClientNodes();
    protected ChannelContextSetWithLock<SessionContext, P, R> connections = new ChannelContextSetWithLock();
    protected ChannelContextSetWithLock<SessionContext, P, R> connecteds = new ChannelContextSetWithLock();
    protected ChannelContextSetWithLock<SessionContext, P, R> closeds = new ChannelContextSetWithLock();
    protected Groups<SessionContext, P, R> groups = new Groups();
    protected Users<SessionContext, P, R> users = new Users();
    protected ChannelContextMapWithLock<SessionContext, P, R> syns = new ChannelContextMapWithLock();
    private boolean isEncodeCareWithChannelContext = true;
    protected String id = ID_ATOMIC.incrementAndGet() + "";
    private boolean isStopped = false;
    private static final AtomicInteger ID_ATOMIC = new AtomicInteger();

    public GroupContext() {
        LinkedBlockingQueue<Runnable> poolQueueNormPrior = new LinkedBlockingQueue<Runnable>();
        SynThreadPoolExecutor executorNormPrior = new SynThreadPoolExecutor(CORE_POOL_SIZE, CORE_POOL_SIZE, 9000000L, poolQueueNormPrior, DefaultThreadFactory.getInstance("t-aio-norm-prior", 5), "t-aio-norm-prior");
        executorNormPrior.prestartAllCoreThreads();
        this.handlerExecutorNormPrior = executorNormPrior;
        this.sendExecutorNormPrior = executorNormPrior;
        LinkedBlockingQueue<Runnable> closeQueue = new LinkedBlockingQueue<Runnable>();
        this.closePoolExecutor = new ThreadPoolExecutor(0, CORE_POOL_SIZE, 9L, TimeUnit.SECONDS, closeQueue, DefaultThreadFactory.getInstance("t-aio-close", 5));
    }

    public SynThreadPoolExecutor<SynRunnableIntf> getHandlerExecutorNormPrior() {
        return this.handlerExecutorNormPrior;
    }

    public void setHandlerExecutorNormPrior(SynThreadPoolExecutor<SynRunnableIntf> handlerExecutorNormPrior) {
        this.handlerExecutorNormPrior = handlerExecutorNormPrior;
    }

    public SynThreadPoolExecutor<SynRunnableIntf> getSendExecutorNormPrior() {
        return this.sendExecutorNormPrior;
    }

    public void setSendExecutorNormPrior(SynThreadPoolExecutor<SynRunnableIntf> sendExecutorNormPrior) {
        this.sendExecutorNormPrior = sendExecutorNormPrior;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public ClientNodes<SessionContext, P, R> getClientNodes() {
        return this.clientNodes;
    }

    public void setClientNodes(ClientNodes<SessionContext, P, R> clientNodes) {
        this.clientNodes = clientNodes;
    }

    public Groups<SessionContext, P, R> getGroups() {
        return this.groups;
    }

    public void setGroups(Groups<SessionContext, P, R> groups) {
        this.groups = groups;
    }

    public Users<SessionContext, P, R> getUsers() {
        return this.users;
    }

    public void setUsers(Users<SessionContext, P, R> users) {
        this.users = users;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public void setHeartbeatTimeout(long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public ChannelContextSetWithLock<SessionContext, P, R> getConnections() {
        return this.connections;
    }

    public void setConnections(ChannelContextSetWithLock<SessionContext, P, R> connections) {
        this.connections = connections;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public abstract AioHandler<SessionContext, P, R> getAioHandler();

    public abstract GroupStat getGroupStat();

    public abstract AioListener<SessionContext, P, R> getAioListener();

    public ReconnConf<SessionContext, P, R> getReconnConf() {
        return this.reconnConf;
    }

    public ChannelContextMapWithLock<SessionContext, P, R> getSyns() {
        return this.syns;
    }

    public void setSyns(ChannelContextMapWithLock<SessionContext, P, R> syns) {
        this.syns = syns;
    }

    public ChannelContextSetWithLock<SessionContext, P, R> getConnecteds() {
        return this.connecteds;
    }

    public void setConnecteds(ChannelContextSetWithLock<SessionContext, P, R> connecteds) {
        this.connecteds = connecteds;
    }

    public ChannelContextSetWithLock<SessionContext, P, R> getCloseds() {
        return this.closeds;
    }

    public void setCloseds(ChannelContextSetWithLock<SessionContext, P, R> closeds) {
        this.closeds = closeds;
    }

    public boolean isEncodeCareWithChannelContext() {
        return this.isEncodeCareWithChannelContext;
    }

    public void setEncodeCareWithChannelContext(boolean isEncodeCareWithChannelContext) {
        this.isEncodeCareWithChannelContext = isEncodeCareWithChannelContext;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public ThreadPoolExecutor getClosePoolExecutor() {
        return this.closePoolExecutor;
    }

    public void setClosePoolExecutor(ThreadPoolExecutor closePoolExecutor) {
        this.closePoolExecutor = closePoolExecutor;
    }

    public PacketHandlerMode getPacketHandlerMode() {
        return this.packetHandlerMode;
    }

    public void setPacketHandlerMode(PacketHandlerMode packetHandlerMode) {
        this.packetHandlerMode = packetHandlerMode;
    }
}

