/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelStat;
import org.tio.core.GroupContext;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.WriteCompletionHandler;
import org.tio.core.intf.Packet;
import org.tio.core.task.DecodeRunnable;
import org.tio.core.task.HandlerRunnable;
import org.tio.core.task.SendRunnable;

public abstract class ChannelContext<SessionContext, P extends Packet, R> {
    private static Logger log = LoggerFactory.getLogger(ChannelContext.class);
    private static final AtomicLong ID_SEQ = new AtomicLong();
    public static final String UNKNOWN_ADDRESS_IP = "$UNKNOWN";
    public static final AtomicInteger UNKNOWN_ADDRESS_PORT_SEQ = new AtomicInteger();
    private GroupContext<SessionContext, P, R> groupContext = null;
    private DecodeRunnable<SessionContext, P, R> decodeRunnable = null;
    private HandlerRunnable<SessionContext, P, R> handlerRunnableNormPrior = null;
    private SendRunnable<SessionContext, P, R> sendRunnableNormPrior = null;
    private ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private ReadCompletionHandler<SessionContext, P, R> readCompletionHandler = null;
    private WriteCompletionHandler<SessionContext, P, R> writeCompletionHandler = null;
    private int reconnCount = 0;
    private String userid;
    private boolean isWaitingClose = false;
    private boolean isClosed = true;
    private boolean isRemoved = false;
    private ChannelStat stat = new ChannelStat();
    private AsynchronousSocketChannel asynchronousSocketChannel;
    private SessionContext sessionContext;
    private Long id = ID_SEQ.incrementAndGet();
    private Node clientNode;
    private Node serverNode;

    public ChannelContext(GroupContext<SessionContext, P, R> groupContext, AsynchronousSocketChannel asynchronousSocketChannel) {
        this.setGroupContext(groupContext);
        this.setAsynchronousSocketChannel(asynchronousSocketChannel);
        this.readCompletionHandler = new ReadCompletionHandler(this);
        this.writeCompletionHandler = new WriteCompletionHandler(this);
    }

    public abstract Node createClientNode(AsynchronousSocketChannel var1) throws IOException;

    public String toString() {
        return this.getClientNode().toString();
    }

    public AsynchronousSocketChannel getAsynchronousSocketChannel() {
        return this.asynchronousSocketChannel;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public long getId() {
        return this.id;
    }

    public Node getClientNode() {
        return this.clientNode;
    }

    public void setAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
        this.asynchronousSocketChannel = asynchronousSocketChannel;
        if (asynchronousSocketChannel != null) {
            try {
                Node clientNode = this.createClientNode(asynchronousSocketChannel);
                this.setClientNode(clientNode);
            }
            catch (IOException e) {
                log.info(e.toString(), (Throwable)e);
                this.assignAnUnknownClientNode();
            }
        } else {
            this.assignAnUnknownClientNode();
        }
    }

    private void assignAnUnknownClientNode() {
        Node clientNode = new Node(UNKNOWN_ADDRESS_IP, UNKNOWN_ADDRESS_PORT_SEQ.incrementAndGet());
        this.setClientNode(clientNode);
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void setId(long id) {
        this.id = id;
    }

    private void setClientNode(Node clientNode) {
        if (this.clientNode != null) {
            try {
                this.groupContext.getClientNodes().remove(this);
            }
            catch (Exception e1) {
                log.error(e1.toString(), (Throwable)e1);
            }
        }
        this.clientNode = clientNode;
        if (this.clientNode != null && !Objects.equals(UNKNOWN_ADDRESS_IP, this.clientNode.getIp())) {
            try {
                this.groupContext.getClientNodes().put(this);
            }
            catch (Exception e1) {
                log.error(e1.toString(), (Throwable)e1);
            }
        }
    }

    public GroupContext<SessionContext, P, R> getGroupContext() {
        return this.groupContext;
    }

    public void setGroupContext(GroupContext<SessionContext, P, R> groupContext) {
        this.groupContext = groupContext;
        if (groupContext != null) {
            this.decodeRunnable = new DecodeRunnable(this);
            this.handlerRunnableNormPrior = new HandlerRunnable(this, groupContext.getHandlerExecutorNormPrior());
            this.sendRunnableNormPrior = new SendRunnable(this, groupContext.getSendExecutorNormPrior());
            groupContext.getConnections().add(this);
        }
    }

    public ReadCompletionHandler<SessionContext, P, R> getReadCompletionHandler() {
        return this.readCompletionHandler;
    }

    public void setReadCompletionHandler(ReadCompletionHandler<SessionContext, P, R> readCompletionHandler) {
        this.readCompletionHandler = readCompletionHandler;
    }

    public DecodeRunnable<SessionContext, P, R> getDecodeRunnable() {
        return this.decodeRunnable;
    }

    public void setDecodeRunnable(DecodeRunnable<SessionContext, P, R> decodeRunnable) {
        this.decodeRunnable = decodeRunnable;
    }

    public HandlerRunnable<SessionContext, P, R> getHandlerRunnableNormPrior() {
        return this.handlerRunnableNormPrior;
    }

    public void setHandlerRunnableNormPrior(HandlerRunnable<SessionContext, P, R> handlerRunnableNormPrior) {
        this.handlerRunnableNormPrior = handlerRunnableNormPrior;
    }

    public SendRunnable<SessionContext, P, R> getSendRunnableNormPrior() {
        return this.sendRunnableNormPrior;
    }

    public void setSendRunnableNormPrior(SendRunnable<SessionContext, P, R> sendRunnableNormPrior) {
        this.sendRunnableNormPrior = sendRunnableNormPrior;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
        if (isClosed && (this.clientNode == null || !UNKNOWN_ADDRESS_IP.equals(this.clientNode.getIp()))) {
            String before = this.toString();
            this.assignAnUnknownClientNode();
            log.info("\u5173\u95ed\u524d{}, \u5173\u95ed\u540e{}", (Object)before, (Object)this);
        }
    }

    public ChannelStat getStat() {
        return this.stat;
    }

    public void setStat(ChannelStat stat) {
        this.stat = stat;
    }

    public WriteCompletionHandler<SessionContext, P, R> getWriteCompletionHandler() {
        return this.writeCompletionHandler;
    }

    public void setWriteCompletionHandler(WriteCompletionHandler<SessionContext, P, R> writeCompletionHandler) {
        this.writeCompletionHandler = writeCompletionHandler;
    }

    public int getReconnCount() {
        return this.reconnCount;
    }

    public void setReconnCount(int reconnCount) {
        this.reconnCount = reconnCount;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public void setServerNode(Node serverNode) {
        this.serverNode = serverNode;
    }

    public ReentrantReadWriteLock getCloseLock() {
        return this.closeLock;
    }

    public boolean isWaitingClose() {
        return this.isWaitingClose;
    }

    public void setWaitingClose(boolean isWaitingClose) {
        this.isWaitingClose = isWaitingClose;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelContext other = (ChannelContext)obj;
        return Objects.equals(other.id, this.id);
    }
}

