/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ChannelContextFilter;
import org.tio.core.CloseRunnable;
import org.tio.core.GroupContext;
import org.tio.core.ObjWithLock;
import org.tio.core.intf.Packet;
import org.tio.core.maintain.ChannelContextMapWithLock;
import org.tio.core.task.SendRunnable;
import org.tio.core.threadpool.SynThreadPoolExecutor;
import org.tio.core.threadpool.intf.SynRunnableIntf;
import org.tio.core.utils.AioUtils;
import org.tio.core.utils.ThreadUtils;

public class Aio {
    private static Logger log = LoggerFactory.getLogger(Aio.class);

    private Aio() {
    }

    public static <SessionContext, P extends Packet, R> ChannelContext<SessionContext, P, R> getChannelContextByClientNode(GroupContext<SessionContext, P, R> groupContext, String clientIp, Integer clientPort) {
        return groupContext.getClientNodes().find(clientIp, clientPort);
    }

    public static <SessionContext, P extends Packet, R> ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> getChannelContextsByGroup(GroupContext<SessionContext, P, R> groupContext, String groupid) {
        return groupContext.getGroups().clients(groupid);
    }

    public static <SessionContext, P extends Packet, R> void bindGroup(ChannelContext<SessionContext, P, R> channelContext, String groupid) {
        channelContext.getGroupContext().getGroups().bind(groupid, channelContext);
    }

    public static <SessionContext, P extends Packet, R> void unbindGroup(ChannelContext<SessionContext, P, R> channelContext) {
        channelContext.getGroupContext().getGroups().unbind(channelContext);
    }

    public static <SessionContext, P extends Packet, R> void unbindGroup(String group, ChannelContext<SessionContext, P, R> channelContext) {
        channelContext.getGroupContext().getGroups().unbind(group, channelContext);
    }

    public static <SessionContext, P extends Packet, R> void bindUser(ChannelContext<SessionContext, P, R> channelContext, String userid) {
        channelContext.getGroupContext().getUsers().bind(userid, channelContext);
    }

    public static <SessionContext, P extends Packet, R> void unbindUser(ChannelContext<SessionContext, P, R> channelContext) {
        channelContext.getGroupContext().getUsers().unbind(channelContext);
    }

    public static <SessionContext, P extends Packet, R> ChannelContext<SessionContext, P, R> getChannelContextByUserid(GroupContext<SessionContext, P, R> groupContext, String userid) {
        return groupContext.getUsers().find(userid);
    }

    public static <SessionContext, P extends Packet, R> void sendToUser(GroupContext<SessionContext, P, R> groupContext, String userid, P packet) {
        ChannelContext<SessionContext, P, R> channelContext = groupContext.getUsers().find(userid);
        Aio.send(channelContext, packet);
    }

    public static <SessionContext, P extends Packet, R> void send(ChannelContext<SessionContext, P, R> channelContext, P packet) {
        if (channelContext == null) {
            log.error("channelContext == null");
            return;
        }
        if (channelContext.isClosed() || channelContext.isRemoved()) {
            log.error("{}, isClosed:{}, isRemoved:{}, stack:{} ", new Object[]{channelContext, channelContext.isClosed(), channelContext.isRemoved(), ThreadUtils.stackTrace()});
            return;
        }
        SendRunnable<SessionContext, P, R> sendRunnable = AioUtils.selectSendRunnable(channelContext, packet);
        sendRunnable.addMsg(packet);
        SynThreadPoolExecutor<SynRunnableIntf> synThreadPoolExecutor = AioUtils.selectSendExecutor(channelContext, packet);
        synThreadPoolExecutor.execute(sendRunnable);
    }

    public static <SessionContext, P extends Packet, R> void send(GroupContext<SessionContext, P, R> groupContext, String ip, int port, P packet) {
        ChannelContext<SessionContext, P, R> channelContext = groupContext.getClientNodes().find(ip, port);
        if (channelContext != null) {
            Aio.send(channelContext, packet);
        } else {
            log.warn("can find channelContext by {}:{}", (Object)ip, (Object)port);
        }
    }

    public static <SessionContext, P extends Packet, R> void sendToGroup(GroupContext<SessionContext, P, R> groupContext, String groupid, P packet, ChannelContextFilter<SessionContext, P, R> channelContextFilter) {
        ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> setWithLock = groupContext.getGroups().clients(groupid);
        if (setWithLock == null) {
            log.error("\u7ec4[{}]\u4e0d\u5b58\u5728", (Object)groupid);
            return;
        }
        Aio.sendToSet(groupContext, setWithLock, packet, channelContextFilter);
    }

    public static <SessionContext, P extends Packet, R> void sendToGroup(GroupContext<SessionContext, P, R> groupContext, String groupid, P packet) {
        Aio.sendToGroup(groupContext, groupid, packet, null);
    }

    public static <SessionContext, P extends Packet, R> void sendToAll(GroupContext<SessionContext, P, R> groupContext, P packet, ChannelContextFilter<SessionContext, P, R> channelContextFilter) {
        ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> setWithLock = groupContext.getConnections().getSetWithLock();
        if (setWithLock == null) {
            log.debug("\u6ca1\u6709\u4efb\u4f55\u8fde\u63a5");
            return;
        }
        Aio.sendToSet(groupContext, setWithLock, packet, channelContextFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <SessionContext, P extends Packet, R> void sendToSet(GroupContext<SessionContext, P, R> groupContext, ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> setWithLock, P packet, ChannelContextFilter<SessionContext, P, R> channelContextFilter) {
        ReentrantReadWriteLock.ReadLock lock = setWithLock.getLock().readLock();
        try {
            lock.lock();
            Set<ChannelContext<SessionContext, P, R>> set = setWithLock.getObj();
            if (set.size() == 0) {
                log.debug("\u96c6\u5408\u4e3a\u7a7a");
                return;
            }
            if (!groupContext.isEncodeCareWithChannelContext()) {
                ByteBuffer byteBuffer = groupContext.getAioHandler().encode(packet, groupContext, null);
                packet.setPreEncodedByteBuffer(byteBuffer);
            }
            for (ChannelContext<SessionContext, P, R> channelContext : set) {
                boolean isfilter;
                if (channelContextFilter != null && !(isfilter = channelContextFilter.filter(channelContext))) continue;
                Aio.send(channelContext, packet);
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <SessionContext, P extends Packet, R> P synSend(ChannelContext<SessionContext, P, R> channelContext, P packet, long timeout) {
        if (channelContext == null) {
            throw new RuntimeException("channelContext == null");
        }
        Integer synSeq = packet.getSynSeq();
        if (synSeq == null || synSeq <= 0) {
            throw new RuntimeException("synSeq\u5fc5\u987b\u5927\u4e8e0");
        }
        ChannelContextMapWithLock<SessionContext, P, R> syns = channelContext.getGroupContext().getSyns();
        try {
            syns.put(synSeq, packet);
            P p = packet;
            synchronized (p) {
                Aio.send(channelContext, packet);
                try {
                    packet.wait(timeout);
                }
                catch (InterruptedException e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            P respPacket = syns.remove(synSeq);
            if (respPacket == null) {
                log.error("respPacket == null,{}", channelContext);
                return null;
            }
            if (respPacket == packet) {
                log.error("\u540c\u6b65\u53d1\u9001\u8d85\u65f6,{}", channelContext);
                return null;
            }
            return respPacket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <SessionContext, P extends Packet, R> void close(ChannelContext<SessionContext, P, R> channelContext, Throwable throwable, String remark, boolean isNeedRemove) {
        if (channelContext == null) {
            log.error("channelContext == null");
            return;
        }
        if (channelContext.isWaitingClose()) {
            log.info("{} \u6b63\u5728\u7b49\u5f85\u88ab\u5173\u95ed", channelContext);
            return;
        }
        ChannelContext<SessionContext, P, R> channelContext2 = channelContext;
        synchronized (channelContext2) {
            channelContext.setWaitingClose(true);
            ThreadPoolExecutor closePoolExecutor = channelContext.getGroupContext().getClosePoolExecutor();
            closePoolExecutor.execute(new CloseRunnable<SessionContext, P, R>(channelContext, throwable, remark, isNeedRemove));
        }
    }

    public static <SessionContext, P extends Packet, R> void close(ChannelContext<SessionContext, P, R> channelContext, Throwable throwable, String remark) {
        Aio.close(channelContext, throwable, remark, false);
    }

    public static <SessionContext, P extends Packet, R> void remove(ChannelContext<SessionContext, P, R> channelContext, Throwable throwable, String remark) {
        Aio.close(channelContext, throwable, remark, true);
    }

    public static <SessionContext, P extends Packet, R> void close(ChannelContext<SessionContext, P, R> channelContext, String remark) {
        Aio.close(channelContext, null, remark);
    }

    public static <SessionContext, P extends Packet, R> void remove(ChannelContext<SessionContext, P, R> channelContext, String remark) {
        Aio.remove(channelContext, null, remark);
    }

    public static <SessionContext, P extends Packet, R> void close(GroupContext<SessionContext, P, R> groupContext, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        ChannelContext<SessionContext, P, R> channelContext = groupContext.getClientNodes().find(clientIp, clientPort);
        Aio.close(channelContext, throwable, remark);
    }

    public static <SessionContext, P extends Packet, R> void remove(GroupContext<SessionContext, P, R> groupContext, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        ChannelContext<SessionContext, P, R> channelContext = groupContext.getClientNodes().find(clientIp, clientPort);
        Aio.remove(channelContext, throwable, remark);
    }
}

