/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupContext;
import org.tio.core.ChannelContext;
import org.tio.core.intf.Packet;
import org.tio.core.threadpool.DefaultThreadFactory;
import org.tio.core.utils.SystemTimer;

public class ReconnConf<SessionContext, P extends Packet, R> {
    private static Logger log = LoggerFactory.getLogger(ChannelContext.class);
    private long interval = 5000L;
    private int retryCount = 0;
    LinkedBlockingQueue<ChannelContext<SessionContext, P, R>> queue = new LinkedBlockingQueue();
    private ThreadPoolExecutor threadPoolExecutor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReconnConf() {
        if (this.threadPoolExecutor != null) return;
        Class<ReconnConf> clazz = ReconnConf.class;
        synchronized (ReconnConf.class) {
            if (this.threadPoolExecutor != null) return;
            this.threadPoolExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), DefaultThreadFactory.getInstance("t-aio-client-reconn"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public ReconnConf(long interval) {
        this();
        this.setInterval(interval);
    }

    public ReconnConf(long interval, int retryCount) {
        this();
        this.interval = interval;
        this.retryCount = retryCount;
    }

    public static <SessionContext, P extends Packet, R> void put(ClientChannelContext<SessionContext, P, R> clientChannelContext) {
        ReconnConf.isNeedReconn(clientChannelContext, true);
    }

    public static <SessionContext, P extends Packet, R> boolean isNeedReconn(ClientChannelContext<SessionContext, P, R> clientChannelContext, boolean putIfTrue) {
        ClientGroupContext clientGroupContext = (ClientGroupContext)clientChannelContext.getGroupContext();
        ReconnConf reconnConf = clientGroupContext.getReconnConf();
        if (reconnConf != null && reconnConf.getInterval() > 0L) {
            if (reconnConf.getRetryCount() <= 0 || reconnConf.getRetryCount() >= clientChannelContext.getReconnCount()) {
                if (putIfTrue) {
                    clientChannelContext.getStat().setTimeInReconnQueue(SystemTimer.currentTimeMillis());
                    reconnConf.getQueue().add(clientChannelContext);
                }
                return true;
            }
            log.info("\u4e0d\u9700\u8981\u91cd\u8fde{}", clientChannelContext);
            return false;
        }
        return false;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public LinkedBlockingQueue<ChannelContext<SessionContext, P, R>> getQueue() {
        return this.queue;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }
}

