/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.AioClient;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupContext;
import org.tio.client.ConnectionCompletionVo;
import org.tio.client.ReconnConf;
import org.tio.client.intf.ClientAioListener;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.intf.Packet;
import org.tio.core.utils.SystemTimer;

public class ConnectionCompletionHandler<SessionContext, P extends Packet, R>
implements CompletionHandler<Void, ConnectionCompletionVo<SessionContext, P, R>> {
    private static Logger log = LoggerFactory.getLogger(ConnectionCompletionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(Void result, ConnectionCompletionVo<SessionContext, P, R> attachment) {
        ConnectionCompletionVo<SessionContext, P, R> connectionCompletionVo = attachment;
        synchronized (connectionCompletionVo) {
            try {
                boolean isReconnect = attachment.isReconnect();
                ClientChannelContext<SessionContext, P, R> channelContext = attachment.getChannelContext();
                AsynchronousSocketChannel asynchronousSocketChannel = attachment.getAsynchronousSocketChannel();
                AioClient<SessionContext, P, R> aioClient = attachment.getAioClient();
                ClientGroupContext<SessionContext, P, R> clientGroupContext = aioClient.getClientGroupContext();
                Node serverNode = attachment.getServerNode();
                String bindIp = attachment.getBindIp();
                Integer bindPort = attachment.getBindPort();
                ClientAioListener<SessionContext, P, R> clientAioListener = clientGroupContext.getClientAioListener();
                if (isReconnect) {
                    channelContext.setAsynchronousSocketChannel(asynchronousSocketChannel);
                    channelContext.getHandlerRunnableNormPrior().setCanceled(false);
                    channelContext.getSendRunnableNormPrior().setCanceled(false);
                    clientGroupContext.getCloseds().remove(channelContext);
                } else {
                    channelContext = new ClientChannelContext<SessionContext, P, R>(clientGroupContext, asynchronousSocketChannel);
                    channelContext.setServerNode(serverNode);
                    channelContext.getStat().setTimeClosed(SystemTimer.currentTimeMillis());
                }
                channelContext.setBindIp(bindIp);
                channelContext.setBindPort(bindPort);
                channelContext.setReconnCount(0);
                channelContext.setClosed(false);
                attachment.setChannelContext(channelContext);
                clientGroupContext.getConnecteds().add(channelContext);
                ReadCompletionHandler readCompletionHandler = channelContext.getReadCompletionHandler();
                ByteBuffer readByteBuffer = readCompletionHandler.getReadByteBuffer();
                readByteBuffer.position(0);
                readByteBuffer.limit(readByteBuffer.capacity());
                asynchronousSocketChannel.read(readByteBuffer, readByteBuffer, readCompletionHandler);
                boolean isConnected = !channelContext.isClosed();
                log.info("connected to {}", (Object)serverNode);
                if (isConnected && !isReconnect) {
                    channelContext.getStat().setTimeFirstConnected(SystemTimer.currentTimeMillis());
                }
                try {
                    clientAioListener.onAfterConnected(channelContext, isConnected, isReconnect);
                }
                catch (Exception e1) {
                    log.error(e1.toString(), (Throwable)e1);
                }
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            attachment.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable e, ConnectionCompletionVo<SessionContext, P, R> attachment) {
        ConnectionCompletionVo<SessionContext, P, R> connectionCompletionVo = attachment;
        synchronized (connectionCompletionVo) {
            ClientChannelContext<SessionContext, P, R> channelContext = null;
            ClientGroupContext<SessionContext, P, R> clientGroupContext = null;
            ClientAioListener<SessionContext, P, R> clientAioListener = null;
            try {
                log.error(e.toString(), e);
                boolean isReconnect = attachment.isReconnect();
                channelContext = attachment.getChannelContext();
                AsynchronousSocketChannel asynchronousSocketChannel = attachment.getAsynchronousSocketChannel();
                AioClient<SessionContext, P, R> aioClient = attachment.getAioClient();
                clientGroupContext = aioClient.getClientGroupContext();
                Node serverNode = attachment.getServerNode();
                clientAioListener = clientGroupContext.getClientAioListener();
                if (channelContext == null) {
                    channelContext = new ClientChannelContext<SessionContext, P, R>(clientGroupContext, asynchronousSocketChannel);
                    channelContext.setServerNode(serverNode);
                    channelContext.getStat().setTimeClosed(SystemTimer.currentTimeMillis());
                }
                if (!isReconnect) {
                    clientGroupContext.getCloseds().add(channelContext);
                }
                attachment.setChannelContext(channelContext);
                try {
                    clientAioListener.onAfterConnected(channelContext, !channelContext.isClosed(), isReconnect);
                }
                catch (Exception e1) {
                    log.error(e1.toString(), (Throwable)e1);
                }
            }
            catch (Exception e1) {
                log.error(e1.toString(), (Throwable)e1);
            }
            finally {
                ReconnConf.put(channelContext);
                attachment.notify();
            }
        }
    }
}

