/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientGroupStat;
import org.tio.client.ConnectionCompletionHandler;
import org.tio.client.DefaultClientAioListener;
import org.tio.client.ReconnConf;
import org.tio.client.intf.ClientAioHandler;
import org.tio.client.intf.ClientAioListener;
import org.tio.core.GroupContext;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.Packet;
import org.tio.core.stat.GroupStat;
import org.tio.core.threadpool.DefaultThreadFactory;

public class ClientGroupContext<SessionContext, P extends Packet, R>
extends GroupContext<SessionContext, P, R> {
    static Logger log = LoggerFactory.getLogger(ClientGroupContext.class);
    private ExecutorService groupExecutor = null;
    private ClientAioHandler<SessionContext, P, R> clientAioHandler = null;
    private ClientAioListener<SessionContext, P, R> clientAioListener = null;
    private ClientGroupStat clientGroupStat = new ClientGroupStat();
    private ConnectionCompletionHandler<SessionContext, P, R> connectionCompletionHandler = new ConnectionCompletionHandler();

    public ClientGroupContext(ClientAioHandler<SessionContext, P, R> aioHandler, ClientAioListener<SessionContext, P, R> aioListener) {
        this(aioHandler, aioListener, null, new ThreadPoolExecutor(CORE_POOL_SIZE, CORE_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), DefaultThreadFactory.getInstance("t-aio-client-group")));
    }

    public ClientGroupContext(ClientAioHandler<SessionContext, P, R> aioHandler, ClientAioListener<SessionContext, P, R> aioListener, ReconnConf<SessionContext, P, R> reconnConf) {
        this(aioHandler, aioListener, reconnConf, new ThreadPoolExecutor(CORE_POOL_SIZE, CORE_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), DefaultThreadFactory.getInstance("t-aio-client-group")));
    }

    public ClientGroupContext(ClientAioHandler<SessionContext, P, R> aioHandler, ClientAioListener<SessionContext, P, R> aioListener, ReconnConf<SessionContext, P, R> reconnConf, ExecutorService groupExecutor) {
        this.setClientAioHandler(aioHandler);
        this.setClientAioListener(aioListener);
        this.reconnConf = reconnConf;
        this.groupExecutor = groupExecutor;
    }

    public ExecutorService getGroupExecutor() {
        return this.groupExecutor;
    }

    public void setGroupExecutor(ExecutorService groupExecutor) {
        this.groupExecutor = groupExecutor;
    }

    public void setClientGroupStat(ClientGroupStat clientGroupStat) {
        this.clientGroupStat = clientGroupStat;
    }

    public ClientGroupStat getClientGroupStat() {
        return this.clientGroupStat;
    }

    public ClientAioHandler<SessionContext, P, R> getClientAioHandler() {
        return this.clientAioHandler;
    }

    public void setClientAioHandler(ClientAioHandler<SessionContext, P, R> clientAioHandler) {
        this.clientAioHandler = clientAioHandler;
    }

    public ClientAioListener<SessionContext, P, R> getClientAioListener() {
        return this.clientAioListener;
    }

    public void setClientAioListener(ClientAioListener<SessionContext, P, R> clientAioListener) {
        this.clientAioListener = clientAioListener;
        if (this.clientAioListener == null) {
            this.clientAioListener = new DefaultClientAioListener();
        }
    }

    @Override
    public AioHandler<SessionContext, P, R> getAioHandler() {
        return this.getClientAioHandler();
    }

    @Override
    public GroupStat getGroupStat() {
        return this.getClientGroupStat();
    }

    @Override
    public AioListener<SessionContext, P, R> getAioListener() {
        return this.getClientAioListener();
    }

    public void setReconnConf(ReconnConf<SessionContext, P, R> reconnConf) {
        this.reconnConf = reconnConf;
    }

    public ConnectionCompletionHandler<SessionContext, P, R> getConnectionCompletionHandler() {
        return this.connectionCompletionHandler;
    }

    public void setConnectionCompletionHandler(ConnectionCompletionHandler<SessionContext, P, R> connectionCompletionHandler) {
        this.connectionCompletionHandler = connectionCompletionHandler;
    }
}

