/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.CloseDeferrable;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorFactoryChain;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorSupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.util.SimplePool;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;

public class CachingClientConnectionFactory
extends AbstractClientConnectionFactory
implements CloseDeferrable {
    private final AbstractClientConnectionFactory targetConnectionFactory;
    private final SimplePool<TcpConnectionSupport> pool;
    private final Map<String, CachedConnection> deferredClosures = new ConcurrentHashMap<String, CachedConnection>();
    private final Set<String> okToRelease = new HashSet<String>();
    private volatile boolean deferClose;

    public CachingClientConnectionFactory(AbstractClientConnectionFactory target, int poolSize) {
        super("", 0);
        target.setSingleUse(true);
        this.targetConnectionFactory = target;
        this.pool = new SimplePool(poolSize, (SimplePool.PoolItemCallback)new SimplePool.PoolItemCallback<TcpConnectionSupport>(){

            public TcpConnectionSupport createForPool() {
                try {
                    return CachingClientConnectionFactory.this.targetConnectionFactory.getConnection();
                }
                catch (Exception e) {
                    throw new MessagingException("Failed to obtain connection", (Throwable)e);
                }
            }

            public boolean isStale(TcpConnectionSupport connection) {
                return !connection.isOpen();
            }

            public void removedFromPool(TcpConnectionSupport connection) {
                connection.close();
            }
        });
    }

    public void setConnectionWaitTimeout(int connectionWaitTimeout) {
        this.pool.setWaitTimeout((long)connectionWaitTimeout);
    }

    public synchronized void setPoolSize(int poolSize) {
        this.pool.setPoolSize(poolSize);
    }

    public int getPoolSize() {
        return this.pool.getPoolSize();
    }

    public int getIdleCount() {
        return this.pool.getIdleCount();
    }

    public int getActiveCount() {
        return this.pool.getActiveCount();
    }

    public int getAllocatedCount() {
        return this.pool.getAllocatedCount();
    }

    @Override
    public TcpConnectionSupport obtainConnection() throws Exception {
        return new CachedConnection((TcpConnectionSupport)this.pool.getItem(), this.getListener());
    }

    @Override
    public void enableCloseDeferral(boolean defer) {
        this.deferClose = defer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeDeferred(String connectionId) {
        Set<String> set = this.okToRelease;
        synchronized (set) {
            CachedConnection deferred = this.deferredClosures.remove(connectionId);
            if (deferred != null) {
                deferred.doClose();
            } else {
                this.okToRelease.add(connectionId);
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.targetConnectionFactory.isRunning();
    }

    public int hashCode() {
        return this.targetConnectionFactory.hashCode();
    }

    public void setComponentName(String componentName) {
        this.targetConnectionFactory.setComponentName(componentName);
    }

    public String getComponentType() {
        return this.targetConnectionFactory.getComponentType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingClientConnectionFactory that = (CachingClientConnectionFactory)o;
        return this.targetConnectionFactory.equals(that.targetConnectionFactory);
    }

    @Override
    public int getSoTimeout() {
        return this.targetConnectionFactory.getSoTimeout();
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.targetConnectionFactory.setSoTimeout(soTimeout);
    }

    @Override
    public int getSoReceiveBufferSize() {
        return this.targetConnectionFactory.getSoReceiveBufferSize();
    }

    @Override
    public void setSoReceiveBufferSize(int soReceiveBufferSize) {
        this.targetConnectionFactory.setSoReceiveBufferSize(soReceiveBufferSize);
    }

    @Override
    public int getSoSendBufferSize() {
        return this.targetConnectionFactory.getSoSendBufferSize();
    }

    @Override
    public void setSoSendBufferSize(int soSendBufferSize) {
        this.targetConnectionFactory.setSoSendBufferSize(soSendBufferSize);
    }

    @Override
    public boolean isSoTcpNoDelay() {
        return this.targetConnectionFactory.isSoTcpNoDelay();
    }

    @Override
    public void setSoTcpNoDelay(boolean soTcpNoDelay) {
        this.targetConnectionFactory.setSoTcpNoDelay(soTcpNoDelay);
    }

    @Override
    public int getSoLinger() {
        return this.targetConnectionFactory.getSoLinger();
    }

    @Override
    public void setSoLinger(int soLinger) {
        this.targetConnectionFactory.setSoLinger(soLinger);
    }

    @Override
    public boolean isSoKeepAlive() {
        return this.targetConnectionFactory.isSoKeepAlive();
    }

    @Override
    public void setSoKeepAlive(boolean soKeepAlive) {
        this.targetConnectionFactory.setSoKeepAlive(soKeepAlive);
    }

    @Override
    public int getSoTrafficClass() {
        return this.targetConnectionFactory.getSoTrafficClass();
    }

    @Override
    public void setSoTrafficClass(int soTrafficClass) {
        this.targetConnectionFactory.setSoTrafficClass(soTrafficClass);
    }

    @Override
    public String getHost() {
        return this.targetConnectionFactory.getHost();
    }

    @Override
    public int getPort() {
        return this.targetConnectionFactory.getPort();
    }

    @Override
    public TcpSender getSender() {
        return this.targetConnectionFactory.getSender();
    }

    @Override
    public Serializer<?> getSerializer() {
        return this.targetConnectionFactory.getSerializer();
    }

    @Override
    public Deserializer<?> getDeserializer() {
        return this.targetConnectionFactory.getDeserializer();
    }

    @Override
    public TcpMessageMapper getMapper() {
        return this.targetConnectionFactory.getMapper();
    }

    @Override
    public void registerListener(TcpListener listener) {
        super.registerListener(listener);
        this.targetConnectionFactory.enableManualListenerRegistration();
    }

    @Override
    public void registerSender(TcpSender sender) {
        this.targetConnectionFactory.registerSender(sender);
    }

    @Override
    public void setTaskExecutor(Executor taskExecutor) {
        this.targetConnectionFactory.setTaskExecutor(taskExecutor);
    }

    @Override
    public void setDeserializer(Deserializer<?> deserializer) {
        this.targetConnectionFactory.setDeserializer(deserializer);
    }

    @Override
    public void setSerializer(Serializer<?> serializer) {
        this.targetConnectionFactory.setSerializer(serializer);
    }

    @Override
    public void setMapper(TcpMessageMapper mapper) {
        this.targetConnectionFactory.setMapper(mapper);
    }

    @Override
    public boolean isSingleUse() {
        return this.targetConnectionFactory.isSingleUse();
    }

    @Override
    public void setSingleUse(boolean singleUse) {
        if (!singleUse && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"singleUse=false is not supported; cached connections are never closed");
        }
    }

    @Override
    public void setInterceptorFactoryChain(TcpConnectionInterceptorFactoryChain interceptorFactoryChain) {
        this.targetConnectionFactory.setInterceptorFactoryChain(interceptorFactoryChain);
    }

    @Override
    public void setLookupHost(boolean lookupHost) {
        this.targetConnectionFactory.setLookupHost(lookupHost);
    }

    @Override
    public boolean isLookupHost() {
        return this.targetConnectionFactory.isLookupHost();
    }

    @Override
    public void forceClose(TcpConnection connection) {
        if (connection instanceof CachedConnection) {
            ((CachedConnection)connection).physicallyClose();
        }
        super.forceClose(connection);
    }

    @Override
    public void start() {
        this.setActive(true);
        this.targetConnectionFactory.start();
        super.start();
    }

    @Override
    public synchronized void stop() {
        this.targetConnectionFactory.stop();
        this.pool.removeAllIdleItems();
    }

    @Override
    public int getPhase() {
        return this.targetConnectionFactory.getPhase();
    }

    @Override
    public boolean isAutoStartup() {
        return this.targetConnectionFactory.isAutoStartup();
    }

    @Override
    public void stop(Runnable callback) {
        this.targetConnectionFactory.stop(callback);
    }

    private class CachedConnection
    extends TcpConnectionInterceptorSupport {
        private volatile boolean released;

        public CachedConnection(TcpConnectionSupport connection, TcpListener tcpListener) {
            super.setTheConnection(connection);
            this.registerListener(tcpListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Set set = CachingClientConnectionFactory.this.okToRelease;
            synchronized (set) {
                if (CachingClientConnectionFactory.this.deferClose && !this.released && !CachingClientConnectionFactory.this.okToRelease.remove(this.getConnectionId())) {
                    CachingClientConnectionFactory.this.deferredClosures.put(this.getConnectionId(), this);
                } else {
                    this.doClose();
                }
            }
        }

        private synchronized void doClose() {
            if (this.released) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Connection " + this.getConnectionId() + " has already been released"));
                }
            } else {
                if (!CachingClientConnectionFactory.this.isRunning()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Factory not running - closing " + this.getConnectionId()));
                    }
                    super.close();
                }
                CachingClientConnectionFactory.this.pool.releaseItem((Object)this.getTheConnection());
                this.released = true;
            }
        }

        @Override
        public String getConnectionId() {
            return "Cached:" + super.getConnectionId();
        }

        public String toString() {
            return this.getConnectionId();
        }

        @Override
        public boolean onMessage(Message<?> message) {
            Message modifiedMessage;
            if (message instanceof ErrorMessage) {
                HashMap<String, Object> headers = new HashMap<String, Object>((Map<String, Object>)message.getHeaders());
                headers.put("ip_connectionId", this.getConnectionId());
                if (headers.get("ip_actualConnectionId") == null) {
                    headers.put("ip_actualConnectionId", message.getHeaders().get((Object)"ip_connectionId"));
                }
                modifiedMessage = new ErrorMessage((Throwable)message.getPayload(), headers);
            } else {
                AbstractIntegrationMessageBuilder messageBuilder = CachingClientConnectionFactory.this.getMessageBuilderFactory().fromMessage(message).setHeader("ip_connectionId", (Object)this.getConnectionId());
                if (message.getHeaders().get((Object)"ip_actualConnectionId") == null) {
                    messageBuilder.setHeader("ip_actualConnectionId", message.getHeaders().get((Object)"ip_connectionId"));
                }
                modifiedMessage = messageBuilder.build();
            }
            TcpListener listener = this.getListener();
            if (listener != null) {
                listener.onMessage(modifiedMessage);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message discarded; no listener: " + message));
            }
            this.close();
            return true;
        }

        private void physicallyClose() {
            this.getTheConnection().close();
        }
    }
}

