/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.util.Map;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class EnvironmentRepositoryPropertySourceLocator
implements PropertySourceLocator {
    private EnvironmentRepository repository;
    private String name;
    private String profiles;
    private String label;

    public EnvironmentRepositoryPropertySourceLocator(EnvironmentRepository repository, String name, String profiles, String label) {
        this.repository = repository;
        this.name = name;
        this.profiles = profiles;
        this.label = label;
    }

    public PropertySource<?> locate(Environment environment) {
        CompositePropertySource composite = new CompositePropertySource("configService");
        for (org.springframework.cloud.config.environment.PropertySource source : this.repository.findOne(this.name, this.profiles, this.label).getPropertySources()) {
            Map map = source.getSource();
            composite.addPropertySource((PropertySource)new MapPropertySource(source.getName(), map));
        }
        return composite;
    }
}

