/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import javax.validation.Validation;
import org.apache.catalina.mbeans.MBeanFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;

@Order(value=-2147483627)
public class BackgroundPreinitializer
implements ApplicationListener<ApplicationEvent> {
    private volatile Thread initializationThread;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartedEvent) {
            this.performInitialization();
        } else if (event instanceof ContextRefreshedEvent) {
            this.awaitInitialization();
        }
    }

    private void performInitialization() {
        try {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    this.runSafely(new MessageConverterInitializer());
                    this.runSafely(new MBeanFactoryInitializer());
                    this.runSafely(new ValidationInitializer());
                }

                public void runSafely(Runnable runnable) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }, "background-preinit");
            thread.start();
            this.initializationThread = thread;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void awaitInitialization() {
        Thread thread = this.initializationThread;
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.initializationThread = null;
            }
        }
    }

    private static class ValidationInitializer
    implements Runnable {
        private ValidationInitializer() {
        }

        @Override
        public void run() {
            Validation.byDefaultProvider().configure();
        }
    }

    private static class MBeanFactoryInitializer
    implements Runnable {
        private MBeanFactoryInitializer() {
        }

        @Override
        public void run() {
            new MBeanFactory();
        }
    }

    private static class MessageConverterInitializer
    implements Runnable {
        private MessageConverterInitializer() {
        }

        @Override
        public void run() {
            new AllEncompassingFormHttpMessageConverter();
        }
    }
}

