/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpUnsupportedEncodingException;
import org.springframework.amqp.UncategorizedAmqpException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.util.Assert;

public abstract class RabbitUtils {
    public static final int DEFAULT_PORT = 5672;
    private static final Log logger = LogFactory.getLog(RabbitUtils.class);

    public static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception ex) {
                logger.debug((Object)("Ignoring Connection exception - assuming already closed: " + ex));
            }
        }
    }

    public static void closeChannel(Channel channel) {
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException ex) {
                logger.debug((Object)"Could not close RabbitMQ Channel", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing RabbitMQ Channel", ex);
            }
        }
    }

    public static void commitIfNecessary(Channel channel) {
        Assert.notNull((Object)channel, (String)"Channel must not be null");
        try {
            channel.txCommit();
        }
        catch (IOException ex) {
            throw new AmqpIOException(ex);
        }
    }

    public static void rollbackIfNecessary(Channel channel) {
        Assert.notNull((Object)channel, (String)"Channel must not be null");
        try {
            channel.txRollback();
        }
        catch (IOException ex) {
            throw new AmqpIOException(ex);
        }
    }

    public static RuntimeException convertRabbitAccessException(Throwable ex) {
        Assert.notNull((Object)ex, (String)"Exception must not be null");
        if (ex instanceof AmqpException) {
            return (AmqpException)ex;
        }
        if (ex instanceof ShutdownSignalException) {
            return new AmqpConnectException((Exception)((ShutdownSignalException)ex));
        }
        if (ex instanceof ConnectException) {
            return new AmqpConnectException((Exception)((ConnectException)ex));
        }
        if (ex instanceof IOException) {
            return new AmqpIOException((IOException)ex);
        }
        if (ex instanceof UnsupportedEncodingException) {
            return new AmqpUnsupportedEncodingException(ex);
        }
        return new UncategorizedAmqpException(ex);
    }

    public static void closeMessageConsumer(Channel channel, String consumerTag, boolean transactional) {
        if (!channel.isOpen()) {
            return;
        }
        try {
            channel.basicCancel(consumerTag);
            if (transactional) {
                channel.basicRecover(true);
            }
        }
        catch (Exception ex) {
            throw RabbitUtils.convertRabbitAccessException(ex);
        }
    }

    public static void declareTransactional(Channel channel) {
        try {
            channel.txSelect();
        }
        catch (IOException e) {
            throw RabbitUtils.convertRabbitAccessException(e);
        }
    }
}

