/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.rabbit.config.NamespaceUtils;
import org.springframework.amqp.rabbit.config.RabbitNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ListenerContainerParser
implements BeanDefinitionParser {
    private static final String LISTENER_ELEMENT = "listener";
    private static final String ID_ATTRIBUTE = "id";
    private static final String QUEUE_NAMES_ATTRIBUTE = "queue-names";
    private static final String QUEUES_ATTRIBUTE = "queues";
    private static final String REF_ATTRIBUTE = "ref";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String MESSAGE_CONVERTER_ATTRIBUTE = "message-converter";
    private static final String RESPONSE_EXCHANGE_ATTRIBUTE = "response-exchange";
    private static final String RESPONSE_ROUTING_KEY_ATTRIBUTE = "response-routing-key";

    ListenerContainerParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compositeDef);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String localName;
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1 || !LISTENER_ELEMENT.equals(localName = parserContext.getDelegate().getLocalName(child))) continue;
            this.parseListener((Element)child, element, parserContext);
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private void parseListener(Element listenerEle, Element containerEle, ParserContext parserContext) {
        String queues;
        String queueNames;
        RootBeanDefinition listenerDef = new RootBeanDefinition();
        listenerDef.setSource(parserContext.extractSource((Object)listenerEle));
        String ref = listenerEle.getAttribute(REF_ATTRIBUTE);
        if (!StringUtils.hasText((String)ref)) {
            parserContext.getReaderContext().error("Listener 'ref' attribute contains empty value.", (Object)listenerEle);
        } else {
            listenerDef.getPropertyValues().add("delegate", (Object)new RuntimeBeanReference(ref));
        }
        String method = null;
        if (listenerEle.hasAttribute(METHOD_ATTRIBUTE) && !StringUtils.hasText((String)(method = listenerEle.getAttribute(METHOD_ATTRIBUTE)))) {
            parserContext.getReaderContext().error("Listener 'method' attribute contains empty value.", (Object)listenerEle);
        }
        listenerDef.getPropertyValues().add("defaultListenerMethod", (Object)method);
        if (containerEle.hasAttribute(MESSAGE_CONVERTER_ATTRIBUTE)) {
            String messageConverter = containerEle.getAttribute(MESSAGE_CONVERTER_ATTRIBUTE);
            if (!StringUtils.hasText((String)messageConverter)) {
                parserContext.getReaderContext().error("Listener container 'message-converter' attribute contains empty value.", (Object)containerEle);
            } else {
                listenerDef.getPropertyValues().add("messageConverter", (Object)new RuntimeBeanReference(messageConverter));
            }
        }
        BeanDefinition containerDef = RabbitNamespaceUtils.parseContainer(containerEle, parserContext);
        if (listenerEle.hasAttribute(RESPONSE_EXCHANGE_ATTRIBUTE)) {
            String responseExchange = listenerEle.getAttribute(RESPONSE_EXCHANGE_ATTRIBUTE);
            listenerDef.getPropertyValues().add("responseExchange", (Object)responseExchange);
        }
        if (listenerEle.hasAttribute(RESPONSE_ROUTING_KEY_ATTRIBUTE)) {
            String responseRoutingKey = listenerEle.getAttribute(RESPONSE_ROUTING_KEY_ATTRIBUTE);
            listenerDef.getPropertyValues().add("responseRoutingKey", (Object)responseRoutingKey);
        }
        listenerDef.setBeanClassName("org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter");
        containerDef.getPropertyValues().add("messageListener", (Object)listenerDef);
        String containerBeanName = containerEle.getAttribute(ID_ATTRIBUTE);
        if (!StringUtils.hasText((String)containerBeanName)) {
            containerBeanName = parserContext.getReaderContext().generateBeanName(containerDef);
        }
        if (!NamespaceUtils.isAttributeDefined(listenerEle, QUEUE_NAMES_ATTRIBUTE) && !NamespaceUtils.isAttributeDefined(listenerEle, QUEUES_ATTRIBUTE)) {
            parserContext.getReaderContext().error("Listener 'queue-names' or 'queues' attribute must be provided.", (Object)listenerEle);
        }
        if (NamespaceUtils.isAttributeDefined(listenerEle, QUEUE_NAMES_ATTRIBUTE) && NamespaceUtils.isAttributeDefined(listenerEle, QUEUES_ATTRIBUTE)) {
            parserContext.getReaderContext().error("Listener 'queue-names' or 'queues' attribute must be provided but not both.", (Object)listenerEle);
        }
        if (StringUtils.hasText((String)(queueNames = listenerEle.getAttribute(QUEUE_NAMES_ATTRIBUTE)))) {
            String[] names = StringUtils.commaDelimitedListToStringArray((String)queueNames);
            ManagedList values = new ManagedList();
            for (int i = 0; i < names.length; ++i) {
                values.add(new TypedStringValue(names[i].trim()));
            }
            containerDef.getPropertyValues().add("queueNames", (Object)values);
        }
        if (StringUtils.hasText((String)(queues = listenerEle.getAttribute(QUEUES_ATTRIBUTE)))) {
            String[] names = StringUtils.commaDelimitedListToStringArray((String)queues);
            ManagedList values = new ManagedList();
            for (int i = 0; i < names.length; ++i) {
                values.add(new RuntimeBeanReference(names[i].trim()));
            }
            containerDef.getPropertyValues().add(QUEUES_ATTRIBUTE, (Object)values);
        }
        parserContext.registerBeanComponent(new BeanComponentDefinition(containerDef, containerBeanName));
    }
}

