/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Map;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingFactoryBean
implements FactoryBean<Binding> {
    private Map<String, Object> arguments;
    private String routingKey = "";
    private String exchange;
    private Queue destinationQueue;
    private Exchange destinationExchange;

    public void setArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setDestinationQueue(Queue destinationQueue) {
        this.destinationQueue = destinationQueue;
    }

    public void setDestinationExchange(Exchange destinationExchange) {
        this.destinationExchange = destinationExchange;
    }

    public Binding getObject() throws Exception {
        Binding.DestinationType destinationType;
        String destination;
        if (this.destinationQueue != null) {
            destination = this.destinationQueue.getName();
            destinationType = Binding.DestinationType.QUEUE;
        } else {
            destination = this.destinationExchange.getName();
            destinationType = Binding.DestinationType.EXCHANGE;
        }
        return new Binding(destination, destinationType, this.exchange, this.routingKey, this.arguments);
    }

    public Class<?> getObjectType() {
        return Binding.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

