/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import jodd.core.JoddCore;
import jodd.io.FastByteArrayOutputStream;
import jodd.io.FastCharArrayWriter;

public class StreamUtil {
    public static void close(Closeable closeable) {
        if (closeable != null) {
            if (closeable instanceof Flushable) {
                try {
                    ((Flushable)((Object)closeable)).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        int read;
        byte[] buffer = new byte[JoddCore.ioBufferSize];
        int count = 0;
        while ((read = input.read(buffer, 0, JoddCore.ioBufferSize)) != -1) {
            output.write(buffer, 0, read);
            count += read;
        }
        return count;
    }

    public static int copy(InputStream input, OutputStream output, int byteCount) throws IOException {
        int read;
        int bufferSize = byteCount > JoddCore.ioBufferSize ? JoddCore.ioBufferSize : byteCount;
        byte[] buffer = new byte[bufferSize];
        int count = 0;
        while (byteCount > 0 && (read = byteCount < bufferSize ? input.read(buffer, 0, byteCount) : input.read(buffer, 0, bufferSize)) != -1) {
            byteCount -= read;
            count += read;
            output.write(buffer, 0, read);
        }
        return count;
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        StreamUtil.copy(input, output, JoddCore.encoding);
    }

    public static void copy(InputStream input, Writer output, int byteCount) throws IOException {
        StreamUtil.copy(input, output, JoddCore.encoding, byteCount);
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        StreamUtil.copy((Reader)new InputStreamReader(input, encoding), output);
    }

    public static void copy(InputStream input, Writer output, String encoding, int byteCount) throws IOException {
        StreamUtil.copy((Reader)new InputStreamReader(input, encoding), output, byteCount);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        int read;
        char[] buffer = new char[JoddCore.ioBufferSize];
        int count = 0;
        while ((read = input.read(buffer, 0, JoddCore.ioBufferSize)) >= 0) {
            output.write(buffer, 0, read);
            count += read;
        }
        output.flush();
        return count;
    }

    public static int copy(Reader input, Writer output, int charCount) throws IOException {
        int read;
        int bufferSize = charCount > JoddCore.ioBufferSize ? JoddCore.ioBufferSize : charCount;
        char[] buffer = new char[bufferSize];
        int count = 0;
        while (charCount > 0 && (read = charCount < bufferSize ? input.read(buffer, 0, charCount) : input.read(buffer, 0, bufferSize)) != -1) {
            charCount -= read;
            count += read;
            output.write(buffer, 0, read);
        }
        return count;
    }

    public static void copy(Reader input, OutputStream output) throws IOException {
        StreamUtil.copy(input, output, JoddCore.encoding);
    }

    public static void copy(Reader input, OutputStream output, int charCount) throws IOException {
        StreamUtil.copy(input, output, JoddCore.encoding, charCount);
    }

    public static void copy(Reader input, OutputStream output, String encoding) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output, encoding);
        StreamUtil.copy(input, (Writer)out);
        ((Writer)out).flush();
    }

    public static void copy(Reader input, OutputStream output, String encoding, int charCount) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output, encoding);
        StreamUtil.copy(input, (Writer)out, charCount);
        ((Writer)out).flush();
    }

    public static byte[] readAvailableBytes(InputStream in) throws IOException {
        int i;
        int j;
        int l = in.available();
        byte[] byteArray = new byte[l];
        for (i = 0; i < l && (j = in.read(byteArray, i, l - i)) >= 0; i += j) {
        }
        if (i < l) {
            throw new IOException("Failed to completely read input stream");
        }
        return byteArray;
    }

    public static byte[] readBytes(InputStream input) throws IOException {
        FastByteArrayOutputStream output = new FastByteArrayOutputStream();
        StreamUtil.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] readBytes(InputStream input, int byteCount) throws IOException {
        FastByteArrayOutputStream output = new FastByteArrayOutputStream();
        StreamUtil.copy(input, (OutputStream)output, byteCount);
        return output.toByteArray();
    }

    public static byte[] readBytes(Reader input) throws IOException {
        FastByteArrayOutputStream output = new FastByteArrayOutputStream();
        StreamUtil.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] readBytes(Reader input, int byteCount) throws IOException {
        FastByteArrayOutputStream output = new FastByteArrayOutputStream();
        StreamUtil.copy(input, (OutputStream)output, byteCount);
        return output.toByteArray();
    }

    public static byte[] readBytes(Reader input, String encoding) throws IOException {
        FastByteArrayOutputStream output = new FastByteArrayOutputStream();
        StreamUtil.copy(input, (OutputStream)output, encoding);
        return output.toByteArray();
    }

    public static byte[] readBytes(Reader input, String encoding, int byteCount) throws IOException {
        FastByteArrayOutputStream output = new FastByteArrayOutputStream();
        StreamUtil.copy(input, output, encoding, byteCount);
        return output.toByteArray();
    }

    public static char[] readChars(InputStream input) throws IOException {
        FastCharArrayWriter output = new FastCharArrayWriter();
        StreamUtil.copy(input, (Writer)output);
        return output.toCharArray();
    }

    public static char[] readChars(InputStream input, int charCount) throws IOException {
        FastCharArrayWriter output = new FastCharArrayWriter();
        StreamUtil.copy(input, (Writer)output, charCount);
        return output.toCharArray();
    }

    public static char[] readChars(InputStream input, String encoding) throws IOException {
        FastCharArrayWriter output = new FastCharArrayWriter();
        StreamUtil.copy(input, (Writer)output, encoding);
        return output.toCharArray();
    }

    public static char[] readChars(InputStream input, String encoding, int charCount) throws IOException {
        FastCharArrayWriter output = new FastCharArrayWriter();
        StreamUtil.copy(input, output, encoding, charCount);
        return output.toCharArray();
    }

    public static char[] readChars(Reader input) throws IOException {
        FastCharArrayWriter output = new FastCharArrayWriter();
        StreamUtil.copy(input, (Writer)output);
        return output.toCharArray();
    }

    public static char[] readChars(Reader input, int charCount) throws IOException {
        FastCharArrayWriter output = new FastCharArrayWriter();
        StreamUtil.copy(input, (Writer)output, charCount);
        return output.toCharArray();
    }

    public static boolean compare(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean compare(Reader input1, Reader input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedReader)) {
            input1 = new BufferedReader(input1);
        }
        if (!(input2 instanceof BufferedReader)) {
            input2 = new BufferedReader(input2);
        }
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }
}

