/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.utils;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class EmbeddedCassandraServerHelper {
    private static Logger log = LoggerFactory.getLogger(EmbeddedCassandraServerHelper.class);
    public static final long DEFAULT_STARTUP_TIMEOUT = 10000L;
    public static final String DEFAULT_TMP_DIR = "target/embeddedCassandra";
    public static final String DEFAULT_CASSANDRA_YML_FILE = "cu-cassandra.yaml";
    public static final String CASSANDRA_RNDPORT_YML_FILE = "cu-cassandra-rndport.yaml";
    public static final String DEFAULT_LOG4J_CONFIG_FILE = "/log4j-embedded-cassandra.properties";
    private static final String INTERNAL_CASSANDRA_KEYSPACE = "system";
    private static final String INTERNAL_CASSANDRA_AUTH_KEYSPACE = "system_auth";
    private static final String INTERNAL_CASSANDRA_DISTRIBUTED_KEYSPACE = "system_distributed";
    private static final String INTERNAL_CASSANDRA_SCHEMA_KEYSPACE = "system_schema";
    private static final String INTERNAL_CASSANDRA_TRACES_KEYSPACE = "system_traces";
    private static CassandraDaemon cassandraDaemon = null;
    private static String launchedYamlFile;

    public static void startEmbeddedCassandra() throws TTransportException, IOException, InterruptedException, ConfigurationException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(10000L);
    }

    public static void startEmbeddedCassandra(long timeout) throws TTransportException, IOException, InterruptedException, ConfigurationException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(DEFAULT_CASSANDRA_YML_FILE, timeout);
    }

    public static void startEmbeddedCassandra(String yamlFile) throws TTransportException, IOException, ConfigurationException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(yamlFile, 10000L);
    }

    public static void startEmbeddedCassandra(String yamlFile, long timeout) throws TTransportException, IOException, ConfigurationException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(yamlFile, DEFAULT_TMP_DIR, timeout);
    }

    public static void startEmbeddedCassandra(String yamlFile, String tmpDir) throws TTransportException, IOException, ConfigurationException {
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(yamlFile, tmpDir, 10000L);
    }

    public static void startEmbeddedCassandra(String yamlFile, String tmpDir, long timeout) throws TTransportException, IOException, ConfigurationException {
        if (cassandraDaemon != null) {
            return;
        }
        if (!StringUtils.startsWith((CharSequence)yamlFile, (CharSequence)"/")) {
            yamlFile = "/" + yamlFile;
        }
        EmbeddedCassandraServerHelper.rmdir(tmpDir);
        EmbeddedCassandraServerHelper.copy(yamlFile, tmpDir);
        File file = new File(tmpDir + yamlFile);
        EmbeddedCassandraServerHelper.readAndAdaptYaml(file);
        EmbeddedCassandraServerHelper.startEmbeddedCassandra(file, tmpDir, timeout);
    }

    public static void startEmbeddedCassandra(File file, String tmpDir, long timeout) throws TTransportException, IOException, ConfigurationException {
        if (cassandraDaemon != null) {
            return;
        }
        EmbeddedCassandraServerHelper.checkConfigNameForRestart(file.getAbsolutePath());
        log.debug("Starting cassandra...");
        log.debug("Initialization needed");
        System.setProperty("cassandra.config", "file:" + file.getAbsolutePath());
        System.setProperty("cassandra-foreground", "true");
        System.setProperty("cassandra.native.epoll.enabled", "false");
        if (System.getProperty("log4j.configuration") == null) {
            EmbeddedCassandraServerHelper.copy(DEFAULT_LOG4J_CONFIG_FILE, tmpDir);
            System.setProperty("log4j.configuration", "file:" + tmpDir + DEFAULT_LOG4J_CONFIG_FILE);
        }
        EmbeddedCassandraServerHelper.cleanupAndLeaveDirs();
        final CountDownLatch startupLatch = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                cassandraDaemon = new CassandraDaemon();
                cassandraDaemon.activate();
                startupLatch.countDown();
            }
        });
        try {
            if (!startupLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                log.error("Cassandra daemon did not start after " + timeout + " ms. Consider increasing the timeout");
                throw new AssertionError((Object)"Cassandra daemon did not start within timeout");
            }
        }
        catch (InterruptedException e) {
            log.error("Interrupted waiting for Cassandra daemon to start:", (Throwable)e);
            throw new AssertionError((Object)e);
        }
        finally {
            executor.shutdown();
        }
    }

    private static void checkConfigNameForRestart(String yamlFile) {
        boolean wasPreviouslyLaunched;
        boolean bl = wasPreviouslyLaunched = launchedYamlFile != null;
        if (wasPreviouslyLaunched && !launchedYamlFile.equals(yamlFile)) {
            throw new UnsupportedOperationException("We can't launch two Cassandra configurations in the same JVM instance");
        }
        launchedYamlFile = yamlFile;
    }

    @Deprecated
    public static void stopEmbeddedCassandra() {
        log.warn("EmbeddedCassandraServerHelper.stopEmbeddedCassandra() is now deprecated, previous version was not fully operating");
    }

    public static void cleanEmbeddedCassandra() {
        EmbeddedCassandraServerHelper.dropKeyspaces();
    }

    public static String getClusterName() {
        return DatabaseDescriptor.getClusterName();
    }

    public static String getHost() {
        return DatabaseDescriptor.getRpcAddress().getHostName();
    }

    public static int getRpcPort() {
        return DatabaseDescriptor.getRpcPort();
    }

    public static int getNativeTransportPort() {
        return DatabaseDescriptor.getNativeTransportPort();
    }

    private static void dropKeyspaces() {
        if (EmbeddedCassandraServerHelper.hasHector()) {
            EmbeddedCassandraServerHelper.dropKeyspacesWithHector();
        } else {
            EmbeddedCassandraServerHelper.dropKeyspacesWithNativeDriver();
        }
    }

    private static boolean hasHector() {
        boolean hector = false;
        try {
            new CassandraHostConfigurator("");
            hector = true;
        }
        catch (NoClassDefFoundError err) {
            hector = false;
        }
        return hector;
    }

    private static void dropKeyspacesWithHector() {
        String host = DatabaseDescriptor.getRpcAddress().getHostName();
        int port = DatabaseDescriptor.getRpcPort();
        log.debug("Cleaning cassandra keyspaces on " + host + ":" + port);
        Cluster cluster = HFactory.getOrCreateCluster((String)"TestCluster", (CassandraHostConfigurator)new CassandraHostConfigurator(host + ":" + port));
        List keyspaces = cluster.describeKeyspaces();
        for (KeyspaceDefinition keyspaceDefinition : keyspaces) {
            String keyspaceName = keyspaceDefinition.getName();
            if (EmbeddedCassandraServerHelper.isSystemKeyspaceName(keyspaceName)) continue;
            cluster.dropKeyspace(keyspaceName);
        }
    }

    private static void dropKeyspacesWithNativeDriver() {
        String host = DatabaseDescriptor.getRpcAddress().getHostName();
        int port = DatabaseDescriptor.getNativeTransportPort();
        try (com.datastax.driver.core.Cluster cluster = com.datastax.driver.core.Cluster.builder().addContactPoint(host).withPort(port).build();
             Session session = cluster.connect();){
            ArrayList<String> keyspaces = new ArrayList<String>();
            for (KeyspaceMetadata keyspaceMetadata : cluster.getMetadata().getKeyspaces()) {
                if (EmbeddedCassandraServerHelper.isSystemKeyspaceName(keyspaceMetadata.getName())) continue;
                keyspaces.add(keyspaceMetadata.getName());
            }
            for (String string : keyspaces) {
                session.execute("DROP KEYSPACE " + string);
            }
        }
    }

    private static boolean isSystemKeyspaceName(String keyspaceName) {
        return INTERNAL_CASSANDRA_KEYSPACE.equals(keyspaceName) || INTERNAL_CASSANDRA_AUTH_KEYSPACE.equals(keyspaceName) || INTERNAL_CASSANDRA_DISTRIBUTED_KEYSPACE.equals(keyspaceName) || INTERNAL_CASSANDRA_SCHEMA_KEYSPACE.equals(keyspaceName) || INTERNAL_CASSANDRA_TRACES_KEYSPACE.equals(keyspaceName);
    }

    private static void rmdir(String dir) throws IOException {
        File dirFile = new File(dir);
        if (dirFile.exists()) {
            FileUtils.deleteRecursive((File)new File(dir));
        }
    }

    private static void copy(String resource, String directory) throws IOException {
        EmbeddedCassandraServerHelper.mkdir(directory);
        String fileName = resource.substring(resource.lastIndexOf("/") + 1);
        File file = new File(directory + System.getProperty("file.separator") + fileName);
        try (InputStream is = EmbeddedCassandraServerHelper.class.getResourceAsStream(resource);
             FileOutputStream out = new FileOutputStream(file);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
        }
    }

    private static void mkdir(String dir) throws IOException {
        FileUtils.createDirectory((String)dir);
    }

    private static void cleanupAndLeaveDirs() throws IOException {
        EmbeddedCassandraServerHelper.mkdirs();
        EmbeddedCassandraServerHelper.cleanup();
        EmbeddedCassandraServerHelper.mkdirs();
        CommitLog commitLog = CommitLog.instance;
        commitLog.getContext();
        commitLog.resetUnsafe(true);
    }

    private static void cleanup() throws IOException {
        File dir;
        String[] directoryNames;
        for (String dirName : directoryNames = new String[]{DatabaseDescriptor.getCommitLogLocation()}) {
            dir = new File(dirName);
            if (!dir.exists()) {
                throw new RuntimeException("No such directory: " + dir.getAbsolutePath());
            }
            FileUtils.deleteRecursive((File)dir);
        }
        for (String dirName : DatabaseDescriptor.getAllDataFileLocations()) {
            dir = new File(dirName);
            if (!dir.exists()) {
                throw new RuntimeException("No such directory: " + dir.getAbsolutePath());
            }
            FileUtils.deleteRecursive((File)dir);
        }
    }

    public static void mkdirs() {
        DatabaseDescriptor.createAllDirectories();
    }

    private static void readAndAdaptYaml(File cassandraConfig) throws IOException {
        String yaml = EmbeddedCassandraServerHelper.readYamlFileToString(cassandraConfig);
        Pattern portPattern = Pattern.compile("^([a-z_]+)_port:\\s*([0-9]+)\\s*$", 8);
        Matcher portMatcher = portPattern.matcher(yaml);
        StringBuffer sb = new StringBuffer();
        boolean replaced = false;
        while (portMatcher.find()) {
            String replacement;
            String portName = portMatcher.group(1);
            int portValue = Integer.parseInt(portMatcher.group(2));
            if (portValue == 0) {
                portValue = EmbeddedCassandraServerHelper.findUnusedLocalPort();
                replacement = portName + "_port: " + portValue;
                replaced = true;
            } else {
                replacement = portMatcher.group(0);
            }
            portMatcher.appendReplacement(sb, replacement);
        }
        portMatcher.appendTail(sb);
        if (replaced) {
            EmbeddedCassandraServerHelper.writeStringToYamlFile(cassandraConfig, sb.toString());
        }
    }

    private static String readYamlFileToString(File yamlFile) throws IOException {
        try (UnicodeReader reader = new UnicodeReader((InputStream)new FileInputStream(yamlFile));){
            StringBuffer sb = new StringBuffer();
            char[] cbuf = new char[1024];
            int readden = reader.read(cbuf);
            while (readden >= 0) {
                sb.append(cbuf, 0, readden);
                readden = reader.read(cbuf);
            }
            String string = sb.toString();
            return string;
        }
    }

    private static void writeStringToYamlFile(File yamlFile, String yaml) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(yamlFile), "utf-8");){
            writer.write(yaml);
        }
    }

    private static int findUnusedLocalPort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
    }
}

