/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.IntentAttachPointTypeFactory;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.impl.BindingTypeImpl;
import org.apache.tuscany.sca.policy.impl.ImplementationTypeImpl;
import org.apache.tuscany.sca.policy.xml.PolicyConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IntentAttachPointTypeProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<IntentAttachPointType>,
PolicyConstants {
    private IntentAttachPointTypeFactory attachPointTypeFactory;
    private PolicyFactory policyFactory;
    private Monitor monitor;

    protected abstract IntentAttachPointType resolveExtensionType(IntentAttachPointType var1, ModelResolver var2) throws ContributionResolveException;

    public IntentAttachPointTypeProcessor(PolicyFactory policyFactory, IntentAttachPointTypeFactory attachPointTypeFactory, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.policyFactory = policyFactory;
        this.attachPointTypeFactory = attachPointTypeFactory;
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "policy-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    public IntentAttachPointType read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        QName type = this.getQName(reader, "type");
        if (type != null) {
            if (type.getLocalPart().startsWith("binding")) {
                IntentAttachPointType bindingType = this.attachPointTypeFactory.createBindingType();
                bindingType.setName(type);
                bindingType.setUnresolved(true);
                this.readAlwaysProvidedIntents(bindingType, reader);
                this.readMayProvideIntents(bindingType, reader);
                return bindingType;
            }
            if (type.getLocalPart().startsWith("implementation")) {
                IntentAttachPointType implType = this.attachPointTypeFactory.createImplementationType();
                implType.setName(type);
                implType.setUnresolved(true);
                this.readAlwaysProvidedIntents(implType, reader);
                this.readMayProvideIntents(implType, reader);
                return implType;
            }
            this.error("UnrecognizedIntentAttachPointType", reader, type);
        } else {
            this.error("RequiredAttributeMissing", reader, "type");
        }
        return null;
    }

    private void readAlwaysProvidedIntents(IntentAttachPointType extnType, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "alwaysProvides");
        if (value != null) {
            List alwaysProvided = extnType.getAlwaysProvidedIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                alwaysProvided.add(intent);
            }
        }
    }

    private void readMayProvideIntents(IntentAttachPointType extnType, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "mayProvide");
        if (value != null) {
            List mayProvide = extnType.getMayProvideIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                mayProvide.add(intent);
            }
        }
    }

    public void write(IntentAttachPointType extnType, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        if (extnType instanceof BindingTypeImpl) {
            writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "bindingType");
        } else if (extnType instanceof ImplementationTypeImpl) {
            writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "implementationType");
        }
        this.writeAlwaysProvidesIntentsAttribute(extnType, writer);
        this.writeMayProvideIntentsAttribute(extnType, writer);
        writer.writeEndElement();
    }

    private void writeMayProvideIntentsAttribute(IntentAttachPointType extnType, XMLStreamWriter writer) throws XMLStreamException {
        StringBuffer sb = new StringBuffer();
        for (Intent intent : extnType.getMayProvideIntents()) {
            writer.writeNamespace(intent.getName().getPrefix(), intent.getName().getNamespaceURI());
            sb.append(intent.getName().getPrefix() + ":" + intent.getName().getLocalPart());
            sb.append(" ");
        }
        if (sb.length() > 0) {
            writer.writeAttribute("mayProvide", sb.toString());
        }
    }

    private void writeAlwaysProvidesIntentsAttribute(IntentAttachPointType extnType, XMLStreamWriter writer) throws XMLStreamException {
        StringBuffer sb = new StringBuffer();
        for (Intent intent : extnType.getAlwaysProvidedIntents()) {
            writer.writeNamespace(intent.getName().getPrefix(), intent.getName().getNamespaceURI());
            sb.append(intent.getName().getPrefix() + ":" + intent.getName().getLocalPart());
            sb.append(" ");
        }
        if (sb.length() > 0) {
            writer.writeAttribute("alwaysProvides", sb.toString());
        }
    }

    public void resolve(IntentAttachPointType extnType, ModelResolver resolver) throws ContributionResolveException {
        if (extnType != null && extnType.isUnresolved()) {
            this.resolveAlwaysProvidedIntents(extnType, resolver);
            this.resolveMayProvideIntents(extnType, resolver);
            extnType.setUnresolved(false);
        }
    }

    private void resolveAlwaysProvidedIntents(IntentAttachPointType extensionType, ModelResolver resolver) throws ContributionResolveException {
        if (extensionType != null) {
            ArrayList<Intent> alwaysProvided = new ArrayList<Intent>();
            for (Intent providedIntent : extensionType.getAlwaysProvidedIntents()) {
                if (providedIntent.isUnresolved()) {
                    if (!(providedIntent = (Intent)resolver.resolveModel(Intent.class, (Object)providedIntent)).isUnresolved()) {
                        alwaysProvided.add(providedIntent);
                        continue;
                    }
                    this.error("AlwaysProvidedIntentNotFound", resolver, providedIntent, extensionType);
                    continue;
                }
                alwaysProvided.add(providedIntent);
            }
            extensionType.getAlwaysProvidedIntents().clear();
            extensionType.getAlwaysProvidedIntents().addAll(alwaysProvided);
        }
    }

    private void resolveMayProvideIntents(IntentAttachPointType extensionType, ModelResolver resolver) throws ContributionResolveException {
        if (extensionType != null) {
            ArrayList<Intent> mayProvide = new ArrayList<Intent>();
            for (Intent providedIntent : extensionType.getMayProvideIntents()) {
                if (providedIntent.isUnresolved()) {
                    if (!(providedIntent = (Intent)resolver.resolveModel(Intent.class, (Object)providedIntent)).isUnresolved()) {
                        mayProvide.add(providedIntent);
                        continue;
                    }
                    this.error("MayProvideIntentNotFound", resolver, providedIntent, extensionType);
                    continue;
                }
                mayProvide.add(providedIntent);
            }
            extensionType.getMayProvideIntents().clear();
            extensionType.getMayProvideIntents().addAll(mayProvide);
        }
    }

    public Class<IntentAttachPointType> getModelType() {
        return IntentAttachPointType.class;
    }
}

