/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.jaas;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.security.jaas.JaasAuthenticationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaasAuthenticationPolicyProcessor
implements StAXArtifactProcessor<JaasAuthenticationPolicy> {
    private static final QName JAAS_AUTHENTICATION_POLICY_QNAME = JaasAuthenticationPolicy.NAME;
    private static final String callbackHandler = "callbackHandler";
    public static final QName CALLBACK_HANDLER_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "callbackHandler");
    public static final QName CONFIGURATION_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "configurationName");
    private Monitor monitor;

    public QName getArtifactType() {
        return JAAS_AUTHENTICATION_POLICY_QNAME;
    }

    public JaasAuthenticationPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "policy-security-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    public JaasAuthenticationPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        JaasAuthenticationPolicy policy = new JaasAuthenticationPolicy();
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    String configurationName;
                    String callbackHandlerClassName;
                    name = reader.getName();
                    if (name.equals(CALLBACK_HANDLER_QNAME) && (callbackHandlerClassName = reader.getElementText()) != null) {
                        policy.setCallbackHandlerClassName(callbackHandlerClassName.trim());
                    }
                    if (!name.equals(CONFIGURATION_QNAME) || (configurationName = reader.getElementText()) == null) break;
                    policy.setConfigurationName(configurationName.trim());
                }
            }
            if (event == 2 && JAAS_AUTHENTICATION_POLICY_QNAME.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    public void write(JaasAuthenticationPolicy policy, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, JAAS_AUTHENTICATION_POLICY_QNAME.getLocalPart(), JAAS_AUTHENTICATION_POLICY_QNAME.getNamespaceURI());
        writer.writeNamespace("tuscany", "http://tuscany.apache.org/xmlns/sca/1.0");
        writer.writeEndElement();
    }

    public Class<JaasAuthenticationPolicy> getModelType() {
        return JaasAuthenticationPolicy.class;
    }

    public void resolve(JaasAuthenticationPolicy policy, ModelResolver resolver) throws ContributionResolveException {
        if (policy.getCallbackHandlerClassName() != null) {
            ClassReference classReference = new ClassReference(policy.getCallbackHandlerClassName());
            Class callbackClass = (classReference = (ClassReference)resolver.resolveModel(ClassReference.class, (Object)classReference)).getJavaClass();
            if (callbackClass == null) {
                this.error("ClassNotFoundException", resolver, policy.getCallbackHandlerClassName());
            } else {
                policy.setCallbackHandlerClass(callbackClass);
                policy.setUnresolved(false);
            }
        }
    }
}

