/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.identity;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.identity.SecurityIdentityPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityIdentityPolicyProcessor
implements StAXArtifactProcessor<SecurityIdentityPolicy> {
    private static final String ROLE = "role";
    private Monitor monitor;

    public QName getArtifactType() {
        return SecurityIdentityPolicy.NAME;
    }

    public SecurityIdentityPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "policy-security-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    public SecurityIdentityPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        SecurityIdentityPolicy policy = new SecurityIdentityPolicy();
        int event = reader.getEventType();
        QName start = reader.getName();
        while (true) {
            switch (event) {
                case 1: {
                    String ac = reader.getName().getLocalPart();
                    if ("runAs".equals(ac)) {
                        String roleName = reader.getAttributeValue(null, ROLE);
                        if (roleName == null) {
                            this.error("RequiredAttributeRolesMissing", reader, new Object[0]);
                            break;
                        }
                        policy.setRunAsRole(roleName);
                        break;
                    }
                    if (!"useCallerIdentity".equals(ac)) break;
                    policy.setUseCallerIdentity(true);
                    break;
                }
                case 2: {
                    if (!start.equals(reader.getName())) break;
                    if (reader.hasNext()) {
                        reader.next();
                    }
                    return policy;
                }
            }
            if (!reader.hasNext()) break;
            event = reader.next();
        }
        return policy;
    }

    public void write(SecurityIdentityPolicy policy, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(SecurityIdentityPolicy.NAME.getLocalPart());
        String child = policy.isUseCallerIdentity() ? "useCallerIdentity" : "runAs";
        writer.writeStartElement(child);
        if (!policy.isUseCallerIdentity()) {
            writer.writeAttribute(ROLE, policy.getRunAsRole());
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public Class<SecurityIdentityPolicy> getModelType() {
        return SecurityIdentityPolicy.class;
    }

    public void resolve(SecurityIdentityPolicy policy, ModelResolver resolver) throws ContributionResolveException {
        if (policy.getRunAsRole() != null) {
            policy.setUnresolved(false);
        }
    }
}

