/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.authentication.basic;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAuthenticationPolicyProcessor
implements StAXArtifactProcessor<BasicAuthenticationPolicy> {
    public QName getArtifactType() {
        return BasicAuthenticationPolicy.BASIC_AUTHENTICATION_POLICY_QNAME;
    }

    public BasicAuthenticationPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
    }

    public BasicAuthenticationPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        BasicAuthenticationPolicy policy = new BasicAuthenticationPolicy();
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (name.equals(this.getArtifactType())) break;
                    if ("userName".equals(name.getLocalPart())) {
                        policy.setUserName(reader.getElementText());
                        break;
                    }
                    if (!"password".equals(name.getLocalPart())) break;
                    policy.setPassword(reader.getElementText());
                }
            }
            if (event == 2 && this.getArtifactType().equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    public void write(BasicAuthenticationPolicy policy, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, this.getArtifactType().getLocalPart(), this.getArtifactType().getNamespaceURI());
        writer.writeNamespace("tuscany", "http://tuscany.apache.org/xmlns/sca/1.0");
        if (policy.getUserName() != null) {
            writer.writeStartElement(prefix, "userName", this.getArtifactType().getNamespaceURI());
            writer.writeCharacters(policy.getUserName());
            writer.writeEndElement();
        }
        if (policy.getPassword() != null) {
            writer.writeStartElement(prefix, "password", this.getArtifactType().getNamespaceURI());
            writer.writeCharacters(policy.getPassword());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public Class<BasicAuthenticationPolicy> getModelType() {
        return BasicAuthenticationPolicy.class;
    }

    public void resolve(BasicAuthenticationPolicy arg0, ModelResolver arg1) throws ContributionResolveException {
    }
}

