/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.http.tomcat.module;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.http.tomcat.TomcatServer;
import org.apache.tuscany.sca.work.WorkScheduler;

public class TomcatRuntimeModuleActivator
implements ModuleActivator {
    private TomcatServer server;

    public void start(ExtensionPointRegistry extensionPointRegistry) {
        ServletHostExtensionPoint servletHosts = (ServletHostExtensionPoint)extensionPointRegistry.getExtensionPoint(ServletHostExtensionPoint.class);
        if (servletHosts.getServletHosts().size() < 1) {
            UtilityExtensionPoint utilities = (UtilityExtensionPoint)extensionPointRegistry.getExtensionPoint(UtilityExtensionPoint.class);
            final WorkScheduler workScheduler = (WorkScheduler)utilities.getUtility(WorkScheduler.class);
            this.server = AccessController.doPrivileged(new PrivilegedAction<TomcatServer>(){

                @Override
                public TomcatServer run() {
                    return new TomcatServer(workScheduler);
                }
            });
            servletHosts.addServletHost((ServletHost)this.server);
        }
    }

    public void stop(ExtensionPointRegistry registry) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (TomcatRuntimeModuleActivator.this.server != null) {
                    TomcatRuntimeModuleActivator.this.server.stop();
                }
                return null;
            }
        });
    }
}

