/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.http.tomcat;

import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ContextConfig;
import org.apache.coyote.http11.Http11Protocol;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.mapper.MappingData;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tuscany.sca.host.http.DefaultResourceServlet;
import org.apache.tuscany.sca.host.http.SecurityContext;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletMappingException;
import org.apache.tuscany.sca.http.tomcat.ServletWrapper;
import org.apache.tuscany.sca.http.tomcat.TomcatDefaultServlet;
import org.apache.tuscany.sca.work.WorkScheduler;

public class TomcatServer
implements ServletHost {
    private static final Logger logger = Logger.getLogger(TomcatServer.class.getName());
    private int defaultPortNumber = 8080;
    private int defaultSSLPortNumber = 443;
    private Map<Integer, Port> ports = new HashMap<Integer, Port>();
    private WorkScheduler workScheduler;
    private String contextPath = "/";

    public TomcatServer(WorkScheduler workScheduler) {
        this.workScheduler = workScheduler;
    }

    public void setDefaultPort(int port) {
        this.defaultPortNumber = port;
    }

    public int getDefaultPort() {
        return this.defaultPortNumber;
    }

    public void stop() throws ServletMappingException {
        if (!this.ports.isEmpty()) {
            try {
                HashSet<Map.Entry<Integer, Port>> entries = new HashSet<Map.Entry<Integer, Port>>(this.ports.entrySet());
                for (Map.Entry entry : entries) {
                    Port port = (Port)entry.getValue();
                    port.getConnector().stop();
                    port.getEngine().stop();
                    this.ports.remove(entry.getKey());
                }
            }
            catch (Exception e) {
                throw new ServletMappingException((Throwable)e);
            }
        }
    }

    public void addServletMapping(String suri, Servlet servlet) {
        this.addServletMapping(suri, servlet, null);
    }

    public void addServletMapping(String suri, Servlet servlet, final SecurityContext securityContext) {
        URL addedURL;
        String host;
        ServletWrapper wrapper;
        String path;
        Context context;
        int portNumber;
        Port port;
        URI uri = URI.create(suri);
        String scheme = null;
        if (securityContext != null && securityContext.isSSLEnabled()) {
            scheme = "https";
        } else {
            scheme = uri.getScheme();
            if (scheme == null) {
                scheme = "http";
            }
        }
        int tmpPortNumber = uri.getPort();
        if (tmpPortNumber == -1) {
            tmpPortNumber = "http".equals(scheme) ? this.defaultPortNumber : this.defaultPortNumber;
        }
        if ((port = this.ports.get(portNumber = tmpPortNumber)) == null) {
            Connector connector;
            final StandardEngine engine = AccessController.doPrivileged(new PrivilegedAction<StandardEngine>(){

                @Override
                public StandardEngine run() {
                    return new StandardEngine();
                }
            });
            engine.setBaseDir("");
            engine.setDefaultHost("localhost");
            engine.setName("engine/" + portNumber);
            final StandardHost host2 = new StandardHost();
            host2.setAppBase("");
            host2.setName("localhost");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    engine.addChild((Container)host2);
                    return null;
                }
            });
            context = new StandardContext();
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            context.setLoader((Loader)new TuscanyLoader(tccl));
            context.setDocBase("");
            context.setPath("");
            ContextConfig config = new ContextConfig();
            context.addLifecycleListener((LifecycleListener)config);
            host2.addChild((Container)context);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws LifecycleException {
                        engine.start();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new ServletMappingException((Throwable)e);
            }
            try {
                final String protocol = scheme;
                connector = AccessController.doPrivileged(new PrivilegedExceptionAction<CustomConnector>(){

                    @Override
                    public CustomConnector run() throws Exception {
                        CustomConnector customConnector = new CustomConnector();
                        customConnector.setPort(portNumber);
                        customConnector.setContainer((Container)engine);
                        if ("https".equalsIgnoreCase(protocol)) {
                            this.configureSSL(customConnector, securityContext);
                            ((Http11Protocol)customConnector.getProtocolHandler()).setSSLEnabled(true);
                        }
                        customConnector.initialize();
                        customConnector.start();
                        return customConnector;
                    }

                    private void configureSSL(CustomConnector customConnector, SecurityContext securityContext2) {
                        String trustStorePass;
                        String trustStore;
                        String trustStoreType;
                        String keyStorePass;
                        String keyStore;
                        String keyStoreType;
                        if (securityContext2 == null) {
                            keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
                            keyStore = System.getProperty("javax.net.ssl.keyStore");
                            keyStorePass = System.getProperty("javax.net.ssl.keyStorePassword");
                            trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                            trustStore = System.getProperty("javax.net.ssl.trustStore");
                            trustStorePass = System.getProperty("javax.net.ssl.trustStorePassword");
                        } else {
                            keyStoreType = securityContext2.getSSLProperties().getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
                            keyStore = securityContext2.getSSLProperties().getProperty("javax.net.ssl.keyStore");
                            keyStorePass = securityContext2.getSSLProperties().getProperty("javax.net.ssl.keyStorePassword");
                            trustStoreType = securityContext2.getSSLProperties().getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                            trustStore = securityContext2.getSSLProperties().getProperty("javax.net.ssl.trustStore");
                            trustStorePass = securityContext2.getSSLProperties().getProperty("javax.net.ssl.trustStorePassword");
                        }
                        customConnector.setProperty("protocol", "TLS");
                        customConnector.setProperty("keytype", keyStoreType);
                        customConnector.setProperty("keystore", keyStore);
                        customConnector.setProperty("keypass", keyStorePass);
                        customConnector.setProperty("trusttype", trustStoreType);
                        customConnector.setProperty("truststore", trustStore);
                        customConnector.setProperty("trustpass", trustStorePass);
                        customConnector.setProperty("clientauth", "false");
                        customConnector.setProtocol("HTTP/1.1");
                        customConnector.setScheme(protocol);
                        customConnector.setProperty("backlog", "10");
                        customConnector.setSecure(true);
                    }
                });
            }
            catch (Exception e) {
                throw new ServletMappingException((Throwable)e);
            }
            port = new Port(engine, host2, connector);
            this.ports.put(portNumber, port);
        }
        if (!(path = uri.getPath()).startsWith("/")) {
            path = '/' + path;
        }
        if (!path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        if (servlet instanceof DefaultResourceServlet) {
            String defaultServletPath = path;
            if (defaultServletPath.endsWith("*")) {
                defaultServletPath = defaultServletPath.substring(0, defaultServletPath.length() - 1);
            }
            if (defaultServletPath.endsWith("/")) {
                defaultServletPath = defaultServletPath.substring(0, defaultServletPath.length() - 1);
            }
            DefaultResourceServlet resourceServlet = (DefaultResourceServlet)servlet;
            TomcatDefaultServlet defaultServlet = new TomcatDefaultServlet(defaultServletPath, resourceServlet.getDocumentRoot());
            wrapper = new ServletWrapper((Servlet)defaultServlet);
        } else {
            wrapper = new ServletWrapper(servlet);
        }
        context = port.getHost().map(path);
        wrapper.setName(path);
        wrapper.addMapping(path);
        context.addChild((Container)wrapper);
        context.addServletMapping(path, path);
        port.getConnector().getMapper().addWrapper("localhost", "", path, (Object)wrapper);
        try {
            wrapper.initServlet();
        }
        catch (ServletException e) {
            throw new ServletMappingException((Throwable)e);
        }
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        try {
            addedURL = new URL(scheme, host, portNumber, path);
        }
        catch (MalformedURLException e) {
            throw new ServletMappingException((Throwable)e);
        }
        logger.info("Added Servlet mapping: " + addedURL);
    }

    public URL getURLMapping(String suri) throws ServletMappingException {
        URL url;
        String host;
        int portNumber;
        URI uri = URI.create(suri);
        String scheme = uri.getScheme();
        if (scheme == null) {
            scheme = "http";
        }
        if ((portNumber = uri.getPort()) == -1) {
            portNumber = this.defaultPortNumber;
        }
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        try {
            url = new URL(scheme, host, portNumber, path);
        }
        catch (MalformedURLException e) {
            throw new ServletMappingException((Throwable)e);
        }
        return url;
    }

    public Servlet getServletMapping(String suri) throws ServletMappingException {
        Port port;
        if (suri == null) {
            return null;
        }
        URI uri = URI.create(suri);
        int portNumber = uri.getPort();
        if (portNumber == -1) {
            portNumber = this.defaultPortNumber;
        }
        if ((port = this.ports.get(portNumber)) == null) {
            return null;
        }
        String mapping = uri.getPath();
        if (!mapping.startsWith("/")) {
            mapping = '/' + mapping;
        }
        if (!mapping.startsWith(this.contextPath)) {
            mapping = this.contextPath + mapping;
        }
        final Context context = port.getHost().map(mapping);
        final MappingData md = new MappingData();
        final MessageBytes mb = MessageBytes.newInstance();
        mb.setString(mapping);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    context.getMapper().map(mb, md);
                    return null;
                }
            });
        }
        catch (Exception e) {
            return null;
        }
        if (md.wrapper instanceof ServletWrapper) {
            ServletWrapper servletWrapper = (ServletWrapper)((Object)md.wrapper);
            return servletWrapper.getServlet();
        }
        return null;
    }

    public Servlet removeServletMapping(String suri) {
        Port port;
        URI uri = URI.create(suri);
        int portNumber = uri.getPort();
        if (portNumber == -1) {
            portNumber = this.defaultPortNumber;
        }
        if ((port = this.ports.get(portNumber)) == null) {
            throw new IllegalStateException("No servlet registered at this URI: " + suri);
        }
        String mapping = uri.getPath();
        if (!mapping.startsWith("/")) {
            mapping = '/' + mapping;
        }
        if (!mapping.startsWith(this.contextPath)) {
            mapping = this.contextPath + mapping;
        }
        final Context context = port.getHost().map(mapping);
        final MappingData md = new MappingData();
        final MessageBytes mb = MessageBytes.newInstance();
        mb.setString(mapping);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    context.getMapper().map(mb, md);
                    return null;
                }
            });
        }
        catch (Exception e) {
            return null;
        }
        if (md.wrapper instanceof ServletWrapper) {
            ServletWrapper servletWrapper = (ServletWrapper)((Object)md.wrapper);
            port.getConnector().getMapper().removeWrapper("localhost", "", mapping);
            try {
                context.removeServletMapping(mapping);
            }
            catch (NegativeArraySizeException e) {
                // empty catch block
            }
            context.removeChild((Container)servletWrapper);
            try {
                servletWrapper.destroyServlet();
            }
            catch (Exception ex) {
                // empty catch block
            }
            logger.info("Removed Servlet mapping: " + suri);
            String[] contextNames = port.getConnector().getMapper().getContextNames();
            if (contextNames == null || contextNames.length == 0) {
                try {
                    port.getConnector().stop();
                    port.getEngine().stop();
                    this.ports.remove(portNumber);
                }
                catch (LifecycleException e) {
                    throw new IllegalStateException(e);
                }
            }
            return servletWrapper.getServlet();
        }
        logger.warning("Trying to Remove servlet mapping: " + mapping + " where mapping is not registered");
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String suri) throws ServletMappingException {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String path) {
        this.contextPath = path;
    }

    private class CustomConnector
    extends Connector {
        CustomConnector() throws Exception {
            this.protocolHandler = new CustomHttpProtocolHandler();
        }

        private class CustomHttpProtocolHandler
        extends Http11Protocol {
            CustomHttpProtocolHandler() {
                this.endpoint = new CustomEndpoint();
                this.endpoint.setExecutor((Executor)new WorkSchedulerExecutor());
            }

            private class CustomEndpoint
            extends JIoEndpoint {
                private Thread acceptorThread;

                private CustomEndpoint() {
                }

                public void start() throws Exception {
                    if (!this.initialized) {
                        this.init();
                    }
                    if (!this.running) {
                        this.running = true;
                        this.paused = false;
                        this.acceptorThread = new Thread((Runnable)((Object)new CustomAcceptor()), this.getName() + "-Acceptor-" + 0);
                        this.acceptorThread.setPriority(this.threadPriority);
                        this.acceptorThread.setDaemon(this.daemon);
                        this.acceptorThread.start();
                    }
                }

                public void stop() {
                    super.stop();
                    try {
                        this.acceptorThread.join();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }

                public int getCurrentThreadsBusy() {
                    return 0;
                }

                private class CustomAcceptor
                extends JIoEndpoint.Acceptor {
                    CustomAcceptor() {
                        super((JIoEndpoint)CustomEndpoint.this);
                    }
                }
            }

            private class WorkSchedulerExecutor
            implements Executor {
                private WorkSchedulerExecutor() {
                }

                public void execute(Runnable command) {
                    TomcatServer.this.workScheduler.scheduleWork(command);
                }
            }
        }
    }

    private class Port {
        private StandardEngine engine;
        private StandardHost host;
        private Connector connector;

        private Port(StandardEngine engine, StandardHost host, Connector connector) {
            this.engine = engine;
            this.host = host;
            this.connector = connector;
        }

        public StandardEngine getEngine() {
            return this.engine;
        }

        public StandardHost getHost() {
            return this.host;
        }

        public Connector getConnector() {
            return this.connector;
        }
    }

    private final class TuscanyLoader
    implements Loader {
        private final ClassLoader tccl;
        private boolean delegate;
        private boolean reloadable;
        private Container container;
        private List<String> repos = new ArrayList<String>();
        private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

        private TuscanyLoader(ClassLoader tccl) {
            this.tccl = tccl;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.add(listener);
        }

        public void addRepository(String repository) {
            this.repos.add(repository);
        }

        public void backgroundProcess() {
        }

        public String[] findRepositories() {
            return this.repos.toArray(new String[this.repos.size()]);
        }

        public Container getContainer() {
            return this.container;
        }

        public boolean getDelegate() {
            return this.delegate;
        }

        public String getInfo() {
            return "Tuscany Loader for Embedded Tomcat";
        }

        public boolean getReloadable() {
            return this.reloadable;
        }

        public boolean modified() {
            return false;
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.remove(listener);
        }

        public void setContainer(Container container) {
            this.container = container;
        }

        public void setDelegate(boolean delegate) {
            this.delegate = delegate;
        }

        public void setReloadable(boolean reloadable) {
            this.reloadable = reloadable;
        }

        public ClassLoader getClassLoader() {
            return this.tccl;
        }
    }
}

